/* $Id: WorkflowAdminManager.java,v 1.7 2005/08/26 04:46:02 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import javax.swing.ActionMap;

import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.swing.HelpViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.action.ActionNames;
import jp.co.argo21.nautica.tool.wfadm.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfadm.action.ExitAction;
import jp.co.argo21.nautica.tool.wfadm.action.HelpAction;
import jp.co.argo21.nautica.tool.wfadm.action.OpenAction;
import jp.co.argo21.nautica.tool.wfadm.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfadm.action.RegisterDefinitionAction;
import jp.co.argo21.nautica.tool.wfadm.action.ShutdownAction;
import jp.co.argo21.nautica.tool.wfadm.action.VersionAction;
import jp.co.argo21.nautica.tool.wfadm.common.BusyDialog;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * Nautica[Nt[^pǗc[Sʂ̊ǗsB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowAdminManager
{
	/** ohpX */
	static private final String BUNDLE_PATH
		= "jp.co.argo21.nautica.tool.wfadm.resources.messages";

	/** \[X}l[W */
	static private ResourceManager resourceManager;
	/** C */
	static private WorkflowAdminFrame mainFrame;
	/** Or[A */
	static private ExceptionViewer exceptionViewer;
	/** o[W */
	static private VersionWindow versionWindow;
	/** wv */
	static private HelpViewer helpViewer;
	/** ANV}bv */
	static private ActionMap actionMap;
	/** ҂_CAO */
	static private BusyDialog busyDialog;

	/**
	 * NsB
	 */
	public static void boot() throws Exception
	{
		resourceManager = new ResourceManager(BUNDLE_PATH);

		//XvbV\
		versionWindow = new VersionWindow();
		versionWindow.setVisible(true);

		//e}l[W̏
		PreferenceManager.create();
		
		//ANV}bv̐
		createActionMap();
		
		//XvbV\̂߂1.5bԂ̖ʏ
		long t = System.currentTimeMillis() + 1500;
		while (System.currentTimeMillis() < t) { /* NOP */ }

		mainFrame = new WorkflowAdminFrame();
		exceptionViewer = new ExceptionViewer(mainFrame, false);
		helpViewer = new HelpViewer();
		busyDialog = new BusyDialog(mainFrame);
		mainFrame.setVisible(true);

		versionWindow.setVisible(false);
	}

	/**
	 * \[X}l[WԂB
	 *
	 * @return	\[X}l[W
	 */
	static public ResourceManager getResourceManager()
	{
		return resourceManager;
	}

	/**
	 * Or[AɗOݒ肷B
	 * 
	 * @param ex	Cӂ̗O
	 */
	static public void setException(Exception ex)
	{
		exceptionViewer.setThrowable(ex);
	}

	/**
	 * Or[AԂB
	 * 
	 * @return Or[A
	 */
	static public ExceptionViewer getExceptionViewer()
	{
		return exceptionViewer;
	}

	/**
	 * wvʂԂB
	 * 
	 * @return wv
	 */
	static public HelpViewer getHelpViewer()
	{
		return helpViewer;
	}

	/**
	 * CʂԂB
	 * 
	 * @return C
	 */
	static public WorkflowAdminFrame getMainFrame()
	{
		return mainFrame;
	}

	/**
	 * o[WʂԂB
	 * 
	 * @return o[W
	 */
	static public VersionWindow getVersionWindow()
	{
		return versionWindow;
	}
	
	/**
	 * ҂_CAO̕\Ԃݒ肷B
	 *
	 * @param visible \
	 */
	static public void runBusyTask(BusyTask task)
	{
		if (task == null) return;
		busyDialog.setTask(task);
	}

	/**
	 * ANV}bvԂB
	 * 
	 * @return	ANV}bv
	 */
	static public ActionMap getActionMap()
	{
		return actionMap;
	}

	/**
	 * ANV}bv쐬B
	 */
	static private void createActionMap()
	{
		actionMap = new ActionMap();

		actionMap.put(ActionNames.REGISTER_DEF,     new RegisterDefinitionAction());
		actionMap.put(ActionNames.OPEN_ENGINE,      new OpenAction());
		actionMap.put(ActionNames.SHUTDOWN_ENGINE,  new ShutdownAction());
		actionMap.put(ActionNames.EXIT,             new ExitAction());

		actionMap.put(ActionNames.EXCEPTION_VIEWER, new ExceptionViewerAction());
		actionMap.put(ActionNames.PREFERENCES,      new PreferencesAction());

		actionMap.put(ActionNames.HELP,             new HelpAction());
		actionMap.put(ActionNames.ABOUT,            new VersionAction());
	}
}
