/* $Id: PreferencesAction.java,v 1.5 2005/08/26 04:46:17 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminFrame;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceComponent;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceDialog;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * Nautica[Nt[^pǗc[̃vt@X\ANVłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class PreferencesAction extends AbstractAction
{
	/**
	 * ̃ANVIꂽƂɎs鏈eB
	 * 
	 * @param e ANVCxg
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		WorkflowAdminFrame frame = WorkflowAdminManager.getMainFrame();
		PreferenceComponent preferenceComponent = new PreferenceComponent();
		PreferenceManager pm = PreferenceManager.getInstance();
		if (PreferenceDialog.showDialog(frame, preferenceComponent)) {
			try {
				pm.save();
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
			}
		} else {
			try {
				pm.load();
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
			}
		}
	}
}
