/* $Id: BusyDialog.java,v 1.4 2005/08/26 04:46:05 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;

/**
 * ҂_CAOłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class BusyDialog extends JDialog
{
	/** Ď^C}[ */
	private Timer timer;
	/** ̃^XN */
	private BusyTask task;

	/**
	 * ҂_CAO\zB
	 */
	public BusyDialog(Frame frame)
	{
		// [__CAOƂĕ\B
		super(frame, true);

		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		JOptionPane optionPane = new JOptionPane();
		JLabel waitLabel = new JLabel(rm.getResource("BusyDialog.waitingMessage"));
		waitLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
		waitLabel.setOpaque(false);
		waitLabel.setForeground(Color.white);

		Container c = this.getContentPane();
		c.add(waitLabel, BorderLayout.CENTER);
		c.setBackground(new Color(0x33, 0x33, 0xAA));

		this.setTitle(rm.getResource("BusyDialog.title"));
		this.pack();
		this.setResizable(false);

		timer = new Timer(
			100, //0.1b
			new ActionListener()
			{
				/**
				 * _CAO̕\𐧌䂷B
				 *
				 * @param e Cxg
				 */
				public void actionPerformed(ActionEvent e)
				{
					if (task == null) return;

					int state = task.getState();
					if (state == BusyTask.INIT) {
						try {
							task.run();
						} catch (Exception ex) {
							hideDialog();
						}
					} else if (state == BusyTask.COMPLETE) {
						hideDialog();
					}
				}
			});
	}

	/**
	 * sׂ^XNݒ肷B
	 *
	 * @param task s^XN
	 */
	public void setTask(BusyTask task)
	{
		if (task == null) return;

		this.task = task;
		showDialog();
	}

	/**
	 * ҂_CAO𒆉ɕ\B
	 */
	private void showDialog()
	{
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int sw = screen.width;
		int sh = screen.height;
		Dimension size = this.getSize();
		this.setLocation((sw - size.width) / 2, (sh - size.height) / 2);

		if ((timer != null) && timer.isRunning()) timer.stop();
		timer.restart();
		
		setVisible(true);
	}

	/**
	 * ҂_CAOB
	 */
	private void hideDialog()
	{
		if ((timer != null) && timer.isRunning()) timer.stop();
		
		setVisible(false);
	}

}
