/* $Id: OpenEngineComponent.java,v 1.3 2005/08/26 04:46:07 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * GWꗗʃRec
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class OpenEngineComponent
extends DialogComponent
{
	/** e[u̗ */
	static private String[] columnNames;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** GWe[u */
	private JTable engineInfoTable;
	/** IꂽGW */
	private EngineInfo selectedEngineInfo;

	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		columnNames = new String[4];
		columnNames[0] = rm.getResource("OpenEngineComponent.columnName.0");
		columnNames[1] = rm.getResource("OpenEngineComponent.columnName.1");
		columnNames[2] = rm.getResource("OpenEngineComponent.columnName.2");
		columnNames[3] = rm.getResource("OpenEngineComponent.columnName.3");
	}

	/**
	 * GWꗗʂ𐶐B
	 */
	public OpenEngineComponent()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		JPanel panel = createEngineInfoPanel(rm);
		addTab(rm.getResource("OpenEngineComponent.tab.0"), panel);

		validate();
	}
	
	/**
	 * GWꗗ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createEngineInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 150);
		panel.setSize(size);
		panel.setPreferredSize(size);

		engineInfoTable = new JTable(new EngineInfoTableModel());
		engineInfoTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(engineInfoTable);

		panel.add(sp,  BorderLayout.CENTER);

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
		selectedEngineInfo = null;
	}

	/**
	 * GWւ̐ڑsB
	 *
	 * @return
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		int selected = engineInfoTable.getSelectedRow();
		if (selected < 0) {
			DialogUtilities.showWarning(rm.getResource("W9001"));
			return false;
		}
		PreferenceManager pm = PreferenceManager.getInstance();
		selectedEngineInfo = pm.getEngineInfo(selected);
		return true;
	}
	
	/**
	 * IꂽGWԂB
	 *
	 * @return GW
	 */
	public EngineInfo getSelectedEngineInfo()
	{
		return selectedEngineInfo;
	}
	
	/**
	 * GWe[u䃂f
	 */
	class EngineInfoTableModel extends AbstractTableModel
	{
		/**
		 * GWe[u䃂f𐶐B
		 */
		EngineInfoTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return columnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			PreferenceManager pm = PreferenceManager.getInstance();
			return pm.getEngineInfoCount();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			PreferenceManager pm = PreferenceManager.getInstance();
			EngineInfo info = pm.getEngineInfo(row);
			if (info == null) return "";
			
			if (col == 0) {
				return info.getName();
			} else if (col == 1) {
				return info.getURL();
			} else if (col == 2) {
				return info.getScope();
			} else if (col == 3) {
				return info.getUser();
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
