/* $Id: PropertyComponent.java,v 1.4 2005/08/26 04:46:08 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;

/**
 * vpeBpʃRec
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class PropertyComponent
extends DialogComponent
{
	/** e[u̗ */
	static private String[] columnNames;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** vpeB */
	private Properties properties;
	
	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		columnNames = new String[2];
		columnNames[0] = rm.getResource("PropertyComponent.columnName.0");
		columnNames[1] = rm.getResource("PropertyComponent.columnName.1");
	}

	/**
	 * vpeBpʂ𐶐B
	 *
	 * @param prop vpeB
	 */
	PropertyComponent(Properties prop)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		properties = prop;
		
		JPanel panel = createPropertyPanel(rm);
		addTab(rm.getResource("PropertyComponent.tab.0"), panel);

		validate();
	}
	
	/**
	 * vpeBꗗ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createPropertyPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 150);
		panel.setSize(size);
		panel.setPreferredSize(size);

		JTable propertyTable = new JTable(new PropertyTableModel());
		propertyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(propertyTable);

		panel.add(sp,  BorderLayout.CENTER);

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
	}

	/**
	 * ɏ͂ȂB
	 *
	 * @return true
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		return true;
	}
	
	/**
	 * vpeBe[u䃂f
	 */
	class PropertyTableModel extends AbstractTableModel
	{
		/**
		 * vpeBe[u䃂f𐶐B
		 */
		PropertyTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return columnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			if (properties == null) return 0;

			return properties.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			if (properties == null) return "";

			//L[ڂ\[gB
			Set keyset = properties.keySet();
			Object[] keys = keyset.toArray(); 
			Arrays.sort(keys);
			
			if (col == 0) {
				for (int i = 0; i < keys.length; i++) {
					if (i == row) return keys[i].toString();
				}
			} else if (col == 1) {
				for (int i = 0; i < keys.length; i++) {
					if (i == row) {
						return properties.get(keys[i]).toString();
					}
				}
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
