/* $Id: PropertyDialog.java,v 1.3 2005/08/26 04:46:06 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.common;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Properties;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;

/**
 * vpeBl\p̃_CAO񋟂B
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class PropertyDialog extends JDialog
{
	/** \DialogComponent */
	private DialogComponent dialogComponent;

	/**
	 * _CAO\B
	 * 
	 * @param c	 eR|[lg
	 * @param title ^Cg
	 * @param prop vpeB
	 */
	static public void showDialog(Component c, String title, Properties prop)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		PropertyDialog dialog = new PropertyDialog(frame, title,  prop);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * _CAO\B
	 * 
	 * @param c	 eR|[lg
	 * @param title ^Cg
	 * @param props vpeB
	 */
	static public void showDialog(Component c, String title, Map props)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		PropertyDialog dialog = new PropertyDialog(frame, title,  props);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame et[
	 * @param title ^Cg
	 * @param prop vpeB
	 */
	private PropertyDialog(Frame frame, String title, Properties prop)
	{
		super(frame, true);
		
		dialogComponent = new PropertyComponent(prop);
		createDialog(title);
		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame et[
	 * @param title ^Cg
	 * @param props vpeB
	 */
	private PropertyDialog(Frame frame, String title, Map props)
	{
		super(frame, true);
		
		dialogComponent = new MultiplePropertyComponent(props);
		createDialog(title);
		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO쐬B
	 *
	 * @param title ^Cg
	 */
	private void createDialog(String title)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		setTitle(rm.getResource("PropertyDialog.title") + "(" + title + ")");
		
		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView((JComponent)dialogComponent);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener closeListener = new CloseAction();
		JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
		closeButton.addActionListener(closeListener);
		buttonPane.add(closeButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();
	}

	/**
	 * {^ꂽƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVisible(false);
		}
	}
}
