/* $Id: DefinitionCache.java,v 1.3 2005/08/26 04:45:56 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.definition.loader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * `t@C̃LbVVXełB
 * LbVpfBNǵA[Ũz[fBNgz̈ȉ̏ꏊƂB
 * (Windows)  ${HOME}/Application Data/Nautica/WorkflowAdmin/DefinitionCache/
 * (Linux)    ${HOME}/.nautica/WorkflowAdmin/DefinitionCache/ 
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
class DefinitionCache {
    /** GR[h */
    private static final String ENCODE = "utf-8";
    
    /** `t@CێLbVpfBNg */
    private String cachedir;

    /** Zp[^ */
    private String separator = System.getProperty("file.separator");
        
    /**
     * DefinitionCache 𐶐B
     */
    DefinitionCache() {
        setCacheDir();        
    }
    
    /**
     * w肳ꂽGWƃpXŃLbVĂt@C
     * ǂݍ݁AԂB
     * Yt@CȂꍇAѓo͗Oꍇ
     * null ԂB
     * 
     * @param engineName GW
     * @param path       pX
     * @return `t@C̕
     */
    String fetch(String engineName, String path) {
        String filepath = cachedir + engineName + separator + path;
        BufferedReader br = null;	    
	    try {	        
		    // t@C擾AǂݍŕԂ 
	        br = new BufferedReader(
	    	        new InputStreamReader(new FileInputStream(filepath), ENCODE));
	        StringBuffer definition = new StringBuffer();
	        while (br.ready()) {
		        definition.append(br.readLine());
		    }
		    return definition.toString();
	        
	    } catch (IOException e){
	        return null;
	        
	    } finally {
	        if (br != null) {
	            try { br.close(); } catch (IOException e) { /* Ignore */ }
	        }
	    }
    }
    
    /**
     * w肳ꂽGWƃpXŁA`t@CƂ
     * LbVpfBNgɕۑB
     * 
     * @param engineName GW
     * @param path       pX
     * @param contents   `t@C̕
     * @throws IOException o͗Oꍇ
     */
    void store(String engineName, String path, String contents)
    throws IOException
    {		
        String filepath = cachedir + engineName + separator + path;
        
		// t@C𐶐
		File file = new File(filepath);
		if (!file.exists()) {
		    File parent = file.getParentFile();
		    parent.mkdirs();
		    
		    file.createNewFile();
		}
		
		// t@Cɏo
		BufferedWriter bw = null;
		try {
		    bw = new BufferedWriter(
			        new OutputStreamWriter(new FileOutputStream(filepath), ENCODE));
			bw.write(contents);
			
		} finally {
		    if (bw != null) {
		        try { bw.close(); } catch (IOException e) { /* Ignore */ }	
		    }
		}
    }
    
    /**
     * LbVpfBNgݒ肷B
     */
    private void setCacheDir() {
    	String path = PreferenceManager.getInstance().getApplicationDataPath();
        cachedir = path + separator + "DefinitionCache" + separator;
    }
}