/* $Id: DefinitionLoader.java,v 1.5 2005/08/26 04:45:57 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.definition.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.PackageDefinitionImpl;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.RepositoryLoaderRemote;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

/**
 * `t@Cǂݍރ[_[łB
 * Y`LbVpfBNgɑ݂ȂꍇA
 * GWɐڑĒ`t@Cǂݍ݁ALbVB
 *
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9    
 */
public class DefinitionLoader {
    /** DefinitionLoader ̃VOg */
    static private DefinitionLoader singleton = new DefinitionLoader();
    
    /** DefinitionCache IuWFNg */
    private DefinitionCache dc;
    
    /**
     * DefinitionLoader 𐶐B
     */
    private DefinitionLoader() {
        dc = new DefinitionCache();
    }
    
    /**
     * DefinitionLoader ̃CX^XԂB
     * 
     * @return DefinitionLoader
     */
    public static DefinitionLoader getInstance() {
        return singleton;
    }

    /**
     * `IuWFNgԂB
     * `݂Ȃꍇ null ԂB
     * 
     * @param  engineName GW
     * @param  path       pX
     * @return `IuWFNg
     * @throws WorkflowException GWւ̐ڑɎsꍇ
     *                            GW̐ؒfɎsꍇ
     * @throws IOException       o͗Oꍇ
     * @throws XmlException      PackageDocument̎擾Ɏsꍇ
     * @throws NamingException   l[~OOꍇ
     * @throws RemoteException   ʐMQꍇ
     */
    public PackageDefinition getDefinition(String engineName, String path) 
    throws WorkflowException, IOException, XmlException,
            NamingException, RemoteException 
    {        
        // LbVɕێĂꍇ
        String definition = dc.fetch(engineName, path);
        if (definition != null && !definition.equals("")) {
            return getPackageDefinition(definition);
        }
        
        // LbVɕێĂȂꍇ
        // GWɐڑĒ`擾Aڑ؂
        PreferenceManager pm = PreferenceManager.getInstance();
        EngineInfo einfo = pm.getEngineInfo(engineName);

        if (einfo == null) {
            return null;
        }
        
		WorkflowServiceAccessor wsa = einfo.getWorkflowServiceAccessor();
        try {
            String sid = wsa.open();
            RepositoryLoaderRemote loader = 
                getRepositoryLoaderRemote(einfo);
            definition = loader.getDefinition(sid, einfo.getAdminKey(), path);
        
        } finally {
            if (wsa != null) { wsa.close(); }
        }
        
        if (definition == null || definition.equals("")) {
            return null;
        }        

        // LbV
        dc.store(engineName, path, definition);
        
        // `IuWFNgԂ
        return getPackageDefinition(definition);
    }   
    
    /**
     * w肳ꂽvZX`ɑΉpXԂB
     * Ȃ null ԂB
     * 
     * @param  engineName GW
     * @param  pdname     vZX`
     * @return pX
     * @throws WorkflowException GWւ̐ڑɎsꍇ
     *                            GW̐ؒfɎsꍇ
     * @throws NamingException   l[~OOꍇ
     * @throws RemoteException   ʐMQꍇ
     */
    public String getDefinitionPath(String engineName, String pdname)
    throws WorkflowException, NamingException, RemoteException
    {
        PreferenceManager pm = PreferenceManager.getInstance();
        EngineInfo einfo = pm.getEngineInfo(engineName);
        
        if (einfo == null) {
            return null;
        }
        
		WorkflowServiceAccessor wsa = einfo.getWorkflowServiceAccessor();
        try {
            String sid = wsa.open();
            RepositoryLoaderRemote loader = 
                getRepositoryLoaderRemote(einfo);

            return loader.getDefinitionPath(sid, pdname);

        } finally {
            if (wsa != null) { wsa.close(); }
        }
    }
    
    /**
     * [gRepositoryLoaderԂB
     * 
     * @param scope GWXR[v
     * @param url   l[~OT[rXURL
     * @return RepositoryLoaderRemote
     * @throws NamingException l[~OOꍇ
     */
    private RepositoryLoaderRemote getRepositoryLoaderRemote(EngineInfo einfo)
    throws NamingException
    {

        String scope = einfo.getScope();
        Context context = einfo.getContext();
        Object ref = context.lookup(scope + "/RepositoryLoader");
        RepositoryLoaderRemote loader =
            (RepositoryLoaderRemote) PortableRemoteObject
                .narrow(ref, RepositoryLoaderRemote.class);
        return loader;
    }
    
    /**
     * 񂩂pbP[W`𐶐ĕԂB
     * 
     * @param contents `̓e\
     * @return pbP[W`IuWFNg
     * @throws XmlException PackageDocument̐Ɏsꍇ
     * @throws IOException  o͗Oꍇ
     */
    private PackageDefinition getPackageDefinition(String contents)
    throws XmlException, IOException 
    {
        InputStream in = null;
        try {
            in = new ByteArrayInputStream(contents.getBytes("utf-8"));
            XmlOptions opts = new XmlOptions();
            opts.setCharacterEncoding("utf-8");
            PackageDocument doc = PackageDocument.Factory.parse(in, opts);
            return new PackageDefinitionImpl(doc);
        } finally {
            if (in != null) {
                try { in.close(); } catch (IOException e) { /* Ignore */ }
            }
        }
    }
}
