/* $Id: RegisterInfoComponent.java,v 1.4 2005/08/26 04:45:55 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.definition.register;

import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import java.util.regex.Pattern;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;

/**
 * `t@Co^͗pʃR|[lg
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class RegisterInfoComponent
extends DialogComponent
{
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** o^pbP[W̓GA */
	private JTextField nameField;
	/** pbP[W΃pX̓GA */
	private JTextField pathField;

	/** ҏWΏۂƂȂĂ`t@Co^ */
	private RegisterInfo registerInfo;
	/** VK쐬ǂ̃tO */
	private boolean isNew;
	
	/**
	 * `t@Co^͗pʃR|[lg𐶐B
	 */
	public RegisterInfoComponent()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		JPanel panel = createRegisterInfoPanel(rm);
		addTab(rm.getResource("RegisterInfoComponent.tab.0"), panel);

		validate();
	}
	
	/**
	 * `t@Co^̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createRegisterInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 80);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("RegisterInfoComponent.label.0"));
		JLabel l1 = new JLabel(rm.getResource("RegisterInfoComponent.label.1"));

		nameField = new JTextField();
		nameField.setDocument(new ByteLimitedDocument(16));

		pathField = new JTextField();
		pathField.setDocument(new ByteLimitedDocument(64));

		panel.add(locate(l0,          10,  10, 100, 25));
		panel.add(locate(l1,          10,  40, 100, 25));
		panel.add(locate(nameField,  110,  10, 190, 25));
		panel.add(locate(pathField,  110,  40, 190, 25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
		nameField.setText("");
		pathField.setText("");
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		if (check()) {
			registerInfo = new RegisterInfo();
			registerInfo.setPackageName(nameField.getText());
			registerInfo.setRegisterPath(pathField.getText());
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * ێĂGWoBGW񂪂Ȃꍇ́A
	 * nullԂB
	 *
	 * @return GW
	 */
	public RegisterInfo getRegisterInfo()
	{
		RegisterInfo info = registerInfo;
		registerInfo = null;
		init();
		return info;
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 */
	private boolean check()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		if (checkName(rm) == false) return false;
		if (checkPath(rm) == false)       return false;
		return true;
	}
	
	/**
	 * pbP[Wo^`FbNB
	 *
	 * @param rm \[X}l[W
	 * @return	`FbN
	 */
	private boolean checkName(ResourceManager rm)
	{
		String s = nameField.getText();
		String pat = "[A-Za-z0-9]*";
		String msg = null;
		if (s == null)                              msg = rm.getResource("E9021");
		else if (s.trim().equals(""))               msg = rm.getResource("E9021");
		else if (Pattern.matches(pat, s) == false) msg = rm.getResource("E9022");

		if (msg != null) {
			DialogUtilities.showError(msg);
			return false;
		}
		return true;
	}
	
	/**
	 * pbP[W΃pX`FbNB
	 *
	 * @param rm \[X}l[W
	 * @return	`FbN
	 */
	private boolean checkPath(ResourceManager rm)
	{
		String separator = System.getProperty("file.separator");
		String s = pathField.getText();
		String msg = null;
		if (s == null)                              msg = rm.getResource("E9023");
		else if (s.trim().equals(""))               msg = rm.getResource("E9023");
		else if (s.trim().startsWith(separator))    msg = rm.getResource("E9024");

		return isValid(msg);
	}
	
	/**
	 * `FbNG[ȂǂԂB
	 *
	 * @param rm \[X}l[W
	 * @return	`FbN
	 */
	private boolean isValid(String msg)
	{
		if (msg != null) {
			DialogUtilities.showError(msg);
			return false;
		}
		return true;
	}
}
