/* $Id: ActivityDefinitionPropertyComponent.java,v 1.3 2005/08/26 04:45:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.Expression;

/**
 * ANeBreB`pvpeBpʃRec
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityDefinitionPropertyComponent
extends DialogComponent
{
	/** vpeBe[u̗ */
	static private String[] pColumnNames;

	/** Jڃe[u̗ */
	static private String[] tColumnNames;

	/** Jڏ̃^Cv */
	static private String[] conditionTypes;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** Jڃe[u */
	private JTable transitionTable;

	/** \GA */
	private JTextArea conditionArea;

	/** vpeB */
	private Properties properties;
	
	/** Jڈꗗ */
	private List transitions;
	
	/** vZXϐꗗ */
	private List variables;
	
	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		pColumnNames = new String[2];
		pColumnNames[0] = rm.getResource("PropertyComponent.columnName.0");
		pColumnNames[1] = rm.getResource("PropertyComponent.columnName.1");

		tColumnNames = new String[2];
		tColumnNames[0] = rm.getResource("TransitionTableModel.columnName.0");
		tColumnNames[1] = rm.getResource("TransitionTableModel.columnName.1");

		conditionTypes = new String[5];
		conditionTypes[0] = rm.getResource("TransitionTableModel.conditionType.0");
		conditionTypes[1] = rm.getResource("TransitionTableModel.conditionType.1");
		conditionTypes[2] = rm.getResource("TransitionTableModel.conditionType.2");
		conditionTypes[3] = rm.getResource("TransitionTableModel.conditionType.3");
		conditionTypes[4] = rm.getResource("TransitionTableModel.conditionType.4");
	}

	/**
	 * vpeBpʂ𐶐B
	 *
	 * @param prop vpeB
	 * @param trs Jڏ
	 * @param vars vZXϐ
	 */
	ActivityDefinitionPropertyComponent(Properties prop, List trs, List vars)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		properties = prop;
		transitions = trs;
		variables = vars;
		
		JPanel pPanel = createPropertyPanel(rm);
		addTab(rm.getResource("ActivityDefinitionPropertyComponent.tab.0"), pPanel);
		JPanel tPanel = createTransitionInfoPanel(rm);
		addTab(rm.getResource("ActivityDefinitionPropertyComponent.tab.1"), tPanel);

		validate();
	}
	
	/**
	 * vpeBꗗ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createPropertyPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 150);
		panel.setSize(size);
		panel.setPreferredSize(size);

		JTable propertyTable = new JTable(new PropertyTableModel());
		propertyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(propertyTable);

		panel.add(sp,  BorderLayout.CENTER);

		validate();
		
		return panel;
	}
	
	/**
	 * Jڏ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createTransitionInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);

		transitionTable = new JTable(new TransitionTableModel());
		transitionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ListSelectionModel tlsm = transitionTable.getSelectionModel();
		tlsm.addListSelectionListener(new TransitionSelectAction());
		JScrollPane sp1 = new JScrollPane();
		sp1.setViewportView(transitionTable);
		sp1.setPreferredSize(new Dimension(500, 100));
		
		conditionArea = new JTextArea();
		conditionArea.setLineWrap(true);
		conditionArea.setEditable(false);
		JScrollPane sp2 = new JScrollPane();
		sp2.setViewportView(conditionArea);
		
		JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT, sp1, sp2);
		split.setDividerLocation(120);
		
		panel.add(split,  BorderLayout.CENTER);

		validate();

		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
	}

	/**
	 * ɏ͂ȂB
	 *
	 * @return true
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		return true;
	}
	
	/**
	 * vpeBe[u䃂f
	 */
	class PropertyTableModel extends AbstractTableModel
	{
		/**
		 * vpeBe[u䃂f𐶐B
		 */
		PropertyTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return pColumnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			if (properties == null) return 0;

			return properties.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return pColumnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			if (properties == null) return "";

			//L[ڂ\[gB
			Set keyset = properties.keySet();
			Object[] keys = keyset.toArray(); 
			Arrays.sort(keys);
			
			if (col == 0) {
				for (int i = 0; i < keys.length; i++) {
					if (i == row) return keys[i].toString();
				}
			} else if (col == 1) {
				for (int i = 0; i < keys.length; i++) {
					if (i == row) {
						return properties.get(keys[i]).toString();
					}
				}
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * JڂIꂽꍇ̏
	 */	
	class TransitionSelectAction implements ListSelectionListener
	{
		/**
		 * IꂽJڏ\B
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				Expression exp = ((TransitionDefinition)transitions.get(selected)).getCondition();
				if (exp != null) {
					conditionArea.setText(exp.getExpressionString(variables));
				} else {
					conditionArea.setText("");
				}
			}
		}
	}
	
	/**
	 * Jڃe[u䃂f
	 */
	class TransitionTableModel extends AbstractTableModel
	{
		/**
		 * Jڃe[u䃂f𐶐B
		 */
		TransitionTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return tColumnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return transitions.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return tColumnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			TransitionDefinition tr = (TransitionDefinition)transitions.get(row);
			if (col == 0) {
				return tr.getDestination().getName();
			} else {
				int type = tr.getType();
				if (type == TransitionDefinition.OTHERWISE) {
					return conditionTypes[1];
				} else if (type == TransitionDefinition.EXCEPTION) {
					return conditionTypes[2];
				} else if (type == TransitionDefinition.DEFAULTEXCEPTION) {
					return conditionTypes[3];
				} else {
					if (tr.getCondition() == null) {
						return conditionTypes[4];
					} else {
						return conditionTypes[0];
					}
				}
			}
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
