/* $Id: ActivityDefinitionPropertyDialog.java,v 1.3 2005/08/26 04:45:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;

/**
 * ANeBreB`pvpeBl\p̃_CAO񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityDefinitionPropertyDialog  extends JDialog
{
	/** \DialogComponent */
	private DialogComponent dialogComponent;

	/**
	 * _CAO\B
	 * 
	 * @param c	 eR|[lg
	 * @param title ^Cg
	 * @param prop vpeB
	 * @param trs Jڏ
	 * @param vars vZXϐ
	 */
	static public void showDialog(Component c, String title, Properties prop, List trs, List vars)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ActivityDefinitionPropertyDialog dialog =
			new ActivityDefinitionPropertyDialog(frame, title,  prop, trs, vars);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame et[
	 * @param title ^Cg
	 * @param prop vpeB
	 * @param trs Jڏ
	 * @param vars vZXϐ
	 */
	private ActivityDefinitionPropertyDialog(Frame frame, String title, Properties prop, List trs, List vars)
	{
		super(frame, true);
		
		dialogComponent = new ActivityDefinitionPropertyComponent(prop, trs, vars);
		createDialog(title);
		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO쐬B
	 *
	 * @param title ^Cg
	 */
	private void createDialog(String title)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		setTitle(rm.getResource("PropertyDialog.title") + "(" + title + ")");
		
		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView((JComponent)dialogComponent);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener closeListener = new CloseAction();
		JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
		closeButton.addActionListener(closeListener);
		buttonPane.add(closeButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();
	}

	/**
	 * {^ꂽƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVisible(false);
		}
	}
}
