/* $Id: AttributeComponent.java,v 1.4 2005/08/26 04:45:43 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;

import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * vZXϐp_CAOɕ\ʃR|[lgB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class AttributeComponent extends DialogComponent
{
	/** ϐACR */
	static private final String ATTRIBUTE_ICON = "attribute-mini";
	
	/** ϐACR */
	static private Icon attributeIcon;
	
	/** e[u̗ */
	static private String[] columnNames;

	/** ^ */
	static private String[] typeNames;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ϐꗗe[u */
	private JTable attrTable;
	/** ϐnҏWGA */
	private JTextField attrField;
	/** ύX{^ */
	private JButton updateButton;
	
	/** ͐ */
	private Document strDocument = new ByteLimitedDocument(128);
	
	/** l͐ */
	private Document numDocument = new NumericDocument(9, true);
	
	/** ^l͐ */
	private Document boolDocument = new BooleanDocument();
	
	/** ϐꗗ */
	private List attributes;
	/** XVϐꗗ */
	private List updateAttributes;
	
	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		attributeIcon = IconManager.getIcon(ATTRIBUTE_ICON);

		columnNames = new String[3];
		columnNames[0] = rm.getResource("AttributeComponent.columnName.0");
		columnNames[1] = rm.getResource("AttributeComponent.columnName.1");
		columnNames[2] = rm.getResource("AttributeComponent.columnName.2");

		typeNames = new String[3];
		typeNames[0] = rm.getResource("AttributeComponent.typeName.0");
		typeNames[1] = rm.getResource("AttributeComponent.typeName.1");
		typeNames[2] = rm.getResource("AttributeComponent.typeName.2");
	}
	
	/**
	 * R|[lg𐶐B
	 */
	public AttributeComponent()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		updateAttributes = new ArrayList();

		JPanel panel = createEditorPanel(rm);
		addTab(rm.getResource("AttributeComponent.tab.0"), panel);

		validate();
	}
	
	/**
	 * vZXϐpl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createEditorPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);

		attrTable = new JTable(new AttributeTableModel());
		attrTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		attrTable.setRowHeight(20);
		attrTable.getColumnModel().getColumn(0).setCellRenderer(new AttributeCellRenderer());
		ListSelectionModel lsm = attrTable.getSelectionModel();
		lsm.addListSelectionListener(new SelectAttributeAction());
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(attrTable);
		
		JPanel fieldPanel = new JPanel();
		fieldPanel.setLayout(new BorderLayout());
		attrField = new JTextField();
		attrField.setDocument(strDocument);
		attrField.setEditable(false);

		updateButton = new JButton(rm.getResource("JButton.label.update"));
		updateButton.addActionListener(new UpdateAttributeAction());

		fieldPanel.add(attrField,    BorderLayout.CENTER);
		fieldPanel.add(updateButton, BorderLayout.EAST);
		
		panel.add(sp,          BorderLayout.CENTER);
		panel.add(fieldPanel,  BorderLayout.SOUTH);

		validate();

		return panel;
	}

	/**
	 * XVꂽϐꗗԂB
	 * 
	 * @return	ϐꗗ
	 */
	public List getUpdatedAttributes()
	{
		return updateAttributes;
	}

	/**
	 * ϐꗗݒ肷B
	 * 
	 * @param attrs ϐꗗ
	 */
	public void setAttributes(List attrs)
	{
		this.attributes = attrs;
	}

	/**
	 * r[B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
	}
	
	/**
	 * ɏ͂ȂB
	 *
	 * @return true
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		return true;
	}
	
	/**
	 * XVB
	 */	
	class UpdateAttributeAction extends AbstractAction
	{
		/**
		 * XVB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			int selected = attrTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("W9001"));
				return;
			}
			Attribute attr = (Attribute)attributes.get(selected);
			attr.setValue(attrField.getText());

			//XVXgɒǉ
			if (updateAttributes.contains(attr)) {
				int ix = updateAttributes.indexOf(attr);
				updateAttributes.set(ix, attr);
			} else {
				updateAttributes.add(attr);
			}
			
			attrTable.clearSelection();
			attrField.setEditable(false);
			attrField.setText("");
			attrTable.updateUI();
		}
	}

	/**
	 * ϐXgȈB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.4 $
	 * @since   Nautica Workflow 0.9
	 */
	class SelectAttributeAction implements ListSelectionListener
	{
		/**
		 * ϐ̌^ɉē̓GA؂ւB
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();

			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				Attribute attr = (Attribute)attributes.get(selected);
				String val = attr.getValue();
				int type = attr.getType();

				if (type == Attribute.INTEGER) {
					attrField.setDocument(numDocument);
					attrField.setHorizontalAlignment(SwingUtilities.RIGHT);
				} else if (type == Attribute.BOOLEAN) {
					attrField.setDocument(boolDocument);
					attrField.setHorizontalAlignment(SwingUtilities.LEFT);
				} else {
					attrField.setDocument(strDocument);
					attrField.setHorizontalAlignment(SwingUtilities.LEFT);
				}

				if (val == null) attrField.setText("");
				else attrField.setText(val.trim());

				attrField.setEditable(true);
			}
		}
	}

	/**
	 * vZXϐe[u䃂f
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.4 $
	 * @since   Nautica Workflow 0.9
	 */
	class AttributeTableModel extends AbstractTableModel
	{
		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return columnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			if (attributes == null) return 0;
			return attributes.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * J̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			Attribute attr = (Attribute)attributes.get(row);

			if (col == 0) {
				return attr;
			} else if (col == 1) {
				int type = attr.getType();

				if (type == Attribute.INTEGER) {
					return typeNames[1];
				} else if (type == Attribute.BOOLEAN) {
					return typeNames[2];
				} else {
					return typeNames[0];
				}
			} else {
				return attr.getValue();
			}
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			if (col == 0) return Attribute.class;
			else return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * ϐe[up̃_[
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.4 $
	 * @since   Nautica Workflow 0.9
	 */
	public class AttributeCellRenderer extends DefaultTableCellRenderer
	{
		/**
		 * _O
		 * 
		 * @param table      e[u
		 * @param o          Ze
		 * @param isSelected I
		 * @param hasFocus   tH[JX
		 * @param row        s
		 * @param column     
		 * @return	_O
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */		
		public Component
		getTableCellRendererComponent(
				JTable table, 
				Object o, 
				boolean isSelected, 
				boolean hasFocus, 
				int row, 
				int column)
		{
			super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);

			Attribute attr = (Attribute)o;
			setText(attr.getName());

			if (attributeIcon != null) setIcon(attributeIcon);
			return this;
		}
	}
}
