/* $Id: AttributeDialog.java,v 1.4 2005/08/26 04:45:45 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;

/**
 * vZXϐp̃_CAO񋟂B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class AttributeDialog extends JDialog
{
	/** ݒ */
	static public final int EVAL_END_OPTION = 0;
	/** ] */
	static public final int EVAL_OPTION = 1;
	/**  */
	static public final int END_OPTION  = 2;

	/** r[e */
	private AttributeComponent dialogComponent;
	/** I */
	private int result = EVAL_END_OPTION;

	/**
	 * vZXϐp̃_CAO𐶐B
	 */
	AttributeDialog()
	{
		super((Frame)null, true);
		
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		setTitle(rm.getResource("AttributeDialog.title"));
		
		dialogComponent = new AttributeComponent();

		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView(dialogComponent);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton evalButton = new JButton(rm.getResource("JButton.label.set"));
		evalButton.setActionCommand("EVALUATE_OPTION");
		evalButton.addActionListener(listener);
		getRootPane().setDefaultButton(evalButton);
		buttonPane.add(evalButton);

		JButton endButton = new JButton(rm.getResource("JButton.label.cancel"));
		endButton.addActionListener(listener);
		buttonPane.add(endButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(null);
	}

	/**
	 * _CAOB
	 */
	private void init()
	{
		result = EVAL_END_OPTION;
		dialogComponent.init();
	}

	/**
	 * ϐꗗԂB
	 * 
	 * @return	ϐꗗ
	 */	
	List getUpdatedAttributes()
	{
		return dialogComponent.getUpdatedAttributes();
	}
	
	/**
	 * ϐꗗݒ肷B
	 * 
	 * @param vars	ϐꗗ
	 */
	void setAttributes(List attrs)
	{
		init();
		dialogComponent.setAttributes(attrs);
	}
	
	/**
	 * _CAOƂ̌ʂԂB
	 * 
	 * @return	
	 */
	int getResult()
	{
		return result;
	}

	/**
	 * _CAOƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * ꂽ{^ɉČʂ؂ւB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("EVALUATE_OPTION".equals(e.getActionCommand())) {
				result = EVAL_OPTION;
			} else {
				result = END_OPTION;
			}
			setVisible(false);
		}
	}
}
