/* $Id: ConcurrentLayer.java,v 1.3 2005/08/26 04:45:45 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;

/**
 * sANeBreBō\铯KwǗB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentLayer
{
	//KẘJnANeBreB
	private ActivityDefinition start;
	//Kw̏IANeBreB
	private ActivityDefinition end;
	//e̓Kw̃Xg
	private ConcurrentLayer parentLayer;
	//铯Kw̃Xg
	private List subLayers = new ArrayList();
	//̃C[ɏANeBreB̃Xg
	private List activities = new ArrayList();

	/**
	 * Kw𐶐B
	 * 
	 * @param p	eKw
	 * @param s	sJnANeBreB
	 * @param e	sIANeBreB
	 */
	public ConcurrentLayer(ConcurrentLayer p, ActivityDefinition s, ActivityDefinition e)
	{
		this.parentLayer = p;
		this.start = s;
		this.end = e;
	}

	/**
	 * Kw𐶐B
	 */
	public ConcurrentLayer()
	{
	}

	/**
	 * KwIDԂB
	 * 
	 * @return	KwID
	 */
	public String getLayerID()
	{
		return start.getBlockID();
	}

	/**
	 * KwɃANeBreBǉB
	 * 
	 * @param def	ANeBreB
	 */	
	public void addLayerDefinition(ActivityDefinition def)
	{
		if (def == null) return;
		activities.add(def);		
	}

	/**
	 * KwǉB
	 * 
	 * @param layer	Kw
	 */	
	public void addLayer(ConcurrentLayer layer)
	{
		if (layer == null) return;
		
		addLayerDefinition(layer.getStartDefinition());
		addLayerDefinition(layer.getEndDefinition());
		subLayers.add(layer);
	}

	/**
	 * Ow̃ANeBreBWĕԂB
	 * 
	 * @param list	WpXg
	 */	
	public void collectAllLayerDefinition(List list)
	{
		Iterator lit = subLayers.iterator();
		while (lit.hasNext()) {
			ConcurrentLayer layer = (ConcurrentLayer)lit.next();
			layer.collectAllLayerDefinition(list);
		}

		Iterator ait = activities.iterator();
		while (ait.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)ait.next();
			if (list.contains(act) == false) list.add(act);
		}
		if (list.contains(start) == false) list.add(start);
		if (list.contains(end) == false) list.add(end);
	}

	/**
	 * ̊Kw̕sJnANeBreBԂB
	 * 
	 * @return	sJnANeBreB
	 */
	public ActivityDefinition getStartDefinition()
	{
		return start;
	}

	/**
	 * ̊Kw̕sIANeBreBԂB
	 * 
	 * @return	sIANeBreB
	 */
	public ActivityDefinition getEndDefinition()
	{
		return end;
	}

	/**
	 * Kw̔wi`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBackgroud(Graphics g, Color c, int grid)
	{
		int x = start.getLogicalX() * grid;
		int y = start.getLogicalY() * grid;
		int w = end.getLogicalX() * grid + grid - x;
		int h = end.getLogicalY() * grid + grid - y;
		
		g.setColor(c);
		g.fillRect(x, y, w, h);
		
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
		}
	}

	/**
	 * Kw̘g`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBorder(Graphics g, Color c, int grid)
	{
		int x = start.getLogicalX() * grid;
		int y = start.getLogicalY() * grid;
		int w = end.getLogicalX() * grid + grid - x;
		int h = end.getLogicalY() * grid + grid - y;

		g.setColor(c);
		g.drawRect(x, y, w, h);
		g.drawRect(x + 1, y + 1, w - 2, h - 2);
		
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
		}
	}

	/**
	 * ̊Kw̕sIANeBreBݒ肷B
	 * 
	 * @param definition	sIANeBreB
	 */
	public void setEndDefinition(ActivityDefinition definition)
	{
		end = definition;
	}

	/**
	 * e̓Kwݒ肷B
	 * 
	 * @param layer	Kw
	 */
	public void setParentLayer(ConcurrentLayer layer)
	{
		parentLayer = layer;
	}

	/**
	 * ̊Kw̕sJnANeBreBݒ肷B
	 * 
	 * @param definition	sJnANeBreB
	 */
	public void setStartDefinition(ActivityDefinition definition)
	{
		start = definition;
	}
}
