/* $Id: ConcurrentLayerManager.java,v 1.3 2005/08/26 04:45:50 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;

/**
 * KwǗ}l[W
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentLayerManager
{
	//铯Kw̃Xg
	private List subLayers = new ArrayList();
	//̃C[ɏANeBreB̃Xg
	private List activities = new ArrayList();

	/**
	 * Kw}l[W𐶐B
	 */
	public ConcurrentLayerManager()
	{
	}

	/**
	 * KwB
	 * 
	 * @param activities	ANeBreBꗗ
	 */
	public void initConcurrentLayer(List activities)
	{
		Map layers = new Hashtable();

		Iterator it = activities.iterator();
		while (it.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)it.next();
			if (act.getType().equals(ActivityDefinition.CONCUR_START)) {
				ConcurrentLayer l = new ConcurrentLayer();
				l.setStartDefinition(act);
				layers.put(act.getBlockID(), l);
			}
		}

		Iterator it2 = activities.iterator();
		while (it2.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)it2.next();
			if (act.getType().equals(ActivityDefinition.CONCUR_START)) {
			} else if (act.getType().equals(ActivityDefinition.CONCUR_END)) {
				ConcurrentLayer l = (ConcurrentLayer)layers.get(act.getBlockID());
				l.setEndDefinition(act);
				String parentID = act.getParentBID();
				if (StringUtils.checkNull(parentID)) {
					addLayer(l);
				} else {
					ConcurrentLayer pl = (ConcurrentLayer)layers.get(parentID);
					l.setParentLayer(pl);
					pl.addLayer(l);
				}
			} else {
				String affID = act.getAffiliateBID();
				if (StringUtils.checkNull(affID)) {
				} else {
					ConcurrentLayer al = (ConcurrentLayer)layers.get(affID);
					al.addLayerDefinition(act);
				}
			}
		}
	}
	
	/**
	 * KwɃANeBreBǉB
	 * 
	 * @param def	ANeBreB
	 */
	public void addLayerDefinition(ActivityDefinition def)
	{
		if (def == null) return;
		activities.add(def);
	}

	/**
	 * 
	 * 
	 * @param layer
	 */	
	public void addLayer(ConcurrentLayer layer)
	{
		if (layer == null) return;
		
		addLayerDefinition(layer.getStartDefinition());
		addLayerDefinition(layer.getEndDefinition());
		subLayers.add(layer);
	}

	/**
	 * Kw̔wi`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */	
	public void paintLayerBackgroud(Graphics g, Color c, int grid)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
		}
	}

	/**
	 * Kw̘g`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBorder(Graphics g, Color c, int grid)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
		}
	}
}
