/* $Id: EngineNode.java,v 1.4 2005/08/26 04:45:44 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import javax.swing.tree.TreeNode;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;

/**
 * GWc[̃gbvm[hłB
 * qm[hƂăvZX`m[hB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class EngineNode implements EngineTreeNode
{
	/** GWr[t[ */
	private EngineViewFrame engineViewFrame;
	
	/** qm[h̔z */
	private Vector children;
	
	/** ݐݒ蒆̃tB^[ */
	private Filter currentFilter;
	
	/**
	 * GWc[̃gbvm[h𐶐B
	 * ̓GWr[ɂЂƂ݂B
	 *
	 * @param frame GWr[t[
	 */
	public EngineNode(EngineViewFrame frame)
	{
		engineViewFrame = frame;
		children = new Vector();
	}

	/**
	 * qm[hEnumerationŕԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration children()
	{
		return children.elements();
	}

	/**
	 * qm[h󂯓邩ǂԂB
	 *
	 * @return l
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren()
	{
		return false;
	}

	/**
	 * CfNXŎw肳ꂽqm[hԂB
	 *
	 * @param childIndex CfNX
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int childIndex)
	{
		return (TreeNode)children.get(childIndex);
	}

	/**
	 * qm[h̐ԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount()
	{
		return children.size();
	}

	/**
	 * w肳ꂽm[h̃CfNXlԂB
	 *
	 * @param node m[h
	 * @return CfNX
	 * @see javax.swing.tree.TreeNode#getIndex(javax.swing.tree.TreeNode)
	 */
	public int getIndex(TreeNode node)
	{
		return children.indexOf(node);
	}
	
	/**
	 * em[hԂBgbvm[hȂ̂ŁAnullԂB
	 *
	 * @return null
	 * @see javax.swing.tree.TreeNode#getParent()
	 */
	public TreeNode getParent()
	{
		return null;
	}

	/**
	 * [m[hǂԂB
	 *
	 * @return [m[hȂtrue
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf()
	{
		return false;
	}
	
	/**
	 * m[hԂB
	 *
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		EngineViewController evc = engineViewFrame.getEngineViewController();
		EngineInfo info = evc.getEngineInfo();
		
		return info.getName();
	}
	
	/**
	 * m[h̏XVB
	 *
	 * @param filter
	 * @throws Exception
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#reload(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void reload(Filter filter) throws Exception
	{
		if (filter != null) {
			currentFilter = filter;
		}
		EngineViewController evc = engineViewFrame.getEngineViewController();
		ProcDef[] defs = evc.getProcessDefinition(currentFilter);
		children.clear();
		for (int i = 0; i < defs.length; i++) {
			ProcessDefinitionNode child = new ProcessDefinitionNode(this, defs[i]);
			children.add(child);
		}
	}
	
	/**
	 * m[h̃vpeBԂB
	 *
	 * @param rm \[X}l[W
	 * @return vpeB
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#getProperties()
	 */
	public Properties getProperties(ResourceManager rm)
	{
		Properties prop = new Properties();

		EngineViewController evc = engineViewFrame.getEngineViewController();
		EngineInfo info = evc.getEngineInfo();
		
		prop.put(rm.getResource("EngineNode.key.0"), info.getName());
		prop.put(rm.getResource("EngineNode.key.1"), info.getURL());
		prop.put(rm.getResource("EngineNode.key.2"), info.getScope());
		prop.put(rm.getResource("EngineNode.key.3"), info.getUser());
		prop.put(rm.getResource("EngineNode.key.4"), info.getPassword());
		prop.put(rm.getResource("EngineNode.key.5"), info.getAdminKey());
		
		return prop;
	}

	/**
	 * GWr[t[ԂB
	 *
	 * @return GWr[t[
	 */
	EngineViewFrame getFrame()
	{
		return engineViewFrame;
	}
}
