/* $Id: EngineViewController.java,v 1.13 2005/08/26 04:45:46 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.definition.loader.DefinitionLoader;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * GWƃNCAgԂ̊֌WǗB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.13 $
 * @since   Nautica Workflow 0.9
 */
public class EngineViewController
{
	/** GW */
	private EngineInfo engineInfo;
	/** vZX`-pX}bsO */
	private Map pathMap = new Hashtable();
	/** pX-vZX`}bsO */
	private Map definitionMap = new Hashtable();
	
	/**
	 * EngineManager𐶐B
	 */
	public EngineViewController(EngineInfo info)
	{
		engineInfo = info;
	}

	/**
	 * GWւ̐ڑmFB
	 *
	 * @return ڑmFʂꍇtrue
	 */
	public boolean checkEngineConnection()
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;
		try {
			session = wsa.open();
        	return true;
		} catch (Exception ex) {
			ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
			ev.setThrowable(ex);
			return false;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * tB^[Ŏw肳ꂽvZX`擾B
	 *
	 * @param filter tB^[Bnullݒ\B
	 * @return vZX`
	 * @throws Exception Cӂ̗O
	 */
	ProcDef[] getProcessDefinition(Filter filter) throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;
		try {
			session = wsa.open();
			DefinitionRepositoryRemote dr = wsa.getDefinitionRepository();
			ProcDef[] defs = dr.getProcessDefinitions(session, filter);
			return defs;
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * tB^[Ŏw肳ꂽvZX擾B
	 *
	 * @param filter tB^[Bnullݒ\B
	 * @return vZX
	 * @throws Exception Cӂ̗O
	 */
	Process[] getProcess(Filter filter) throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;
		
		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			Process[] procs = weh.getProcesses(session, filter);
			return procs;
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * vZXIDŎw肳ꂽvZX擾B
	 *
	 * @param pid vZXIDB
	 * @return vZX
	 * @throws Exception Cӂ̗O
	 */
	Process getProcess(String pid) throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;
		
		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			Process proc = weh.getProcess(session, pid);
			return proc;
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * vZXƃtB^[Ŏw肳ꂽANeBreB擾B
	 *
	 * @param proc vZX
	 * @param filter tB^[Bnullݒ\B
	 * @return ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	Activity[] getActivities(Process proc, Filter filter) throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;

		try {
			String pid = proc.getID();
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			Activity[] acts = weh.getActivities(session, pid, filter);
			return acts;
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * ێĂGWԂB
	 *
	 * @return GW
	 */
	EngineInfo getEngineInfo()
	{
		return engineInfo;
	}
	
	/**
	 * Ɏw肳ꂽvZX`܂ރpbP[W`擾B
	 *
	 * @param pdname vZX`
	 * @return pbP[W`
	 * @throws Exception Cӂ̗O
	 */
	PackageDefinition getPackgeDefinition(String pdname)
	throws Exception
	{
		String ename = engineInfo.getName();
		String path = getDefinitionPath(ename, pdname);
		PackageDefinition def = getDefinition(ename, path);
		return def;
	}
	
	/**
	 * vZX̏ԂύXB
	 *
	 * @param pid vZXID
	 * @param state vZX
	 * @throws Exception Cӂ̗O
	 */
	void changeProcessState(String pid, ProcessState state)
	throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;

		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			weh.changeProcessState(session, pid, state);
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * ANeBreB̏ԂύXB
	 *
	 * @param pid vZXID
	 * @param aid ANeBreBID
	 * @param state ANeBreB
	 * @throws Exception Cӂ̗O
	 */
	void changeActivityState(String pid, String aid, ActivityState state)
	throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;

		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			weh.changeActivityState(session, pid, aid, state);
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * vZX̏ԂύXB
	 *
	 * @param pid vZXID
	 * @param filter tB^[BnullwB
	 * @return vZXϐꗗ
	 * @throws Exception Cӂ̗O
	 */
	List getProcessAttributes(String pid, Filter filter)
	throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;

		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			Attribute[] attrs = weh.getProcessAttributes(session, pid, filter);
			return Arrays.asList(attrs);
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
	 * vZX̏ԂύXB
	 *
	 * @param pid vZXID
	 * @param attrs vZXϐꗗ
	 * @throws Exception Cӂ̗O
	 */
	void setProcessAttributes(String pid, List attrs)
	throws Exception
	{
		WorkflowServiceAccessor wsa = engineInfo.getWorkflowServiceAccessor();
		String session = null;
		if (attrs == null) return;

		try {
			session = wsa.open();
			WorkflowEngineHandlerRemote weh = wsa.getWorkflowEngineHandler();
			Iterator it = attrs.iterator();
			while (it.hasNext()) {
				Attribute attr = (Attribute)it.next();
				weh.assignProcessAttribute(session, pid, attr);
			}
		} catch (Exception ex) {
			throw ex;
		} finally {
			if (session != null) {
				try {
					wsa.close();
				} catch (Exception ex) {
					ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
					ev.setThrowable(ex);
				}
			}
		}
	}
	
	/**
     * w肳ꂽvZX`ɑΉpXԂB
     * Ȃ null ԂB
     * 
     * @param eame GW
     * @param pdname vZX`
     * @return pX
	 * @throws Exception Cӂ̗O
	 */
	private String getDefinitionPath(String ename, String pdname)
	throws Exception
	{
		String path = (String)pathMap.get(pdname);
		
		if (path == null) {
			DefinitionLoader loader = DefinitionLoader.getInstance();
			path = loader.getDefinitionPath(ename, pdname);
		}
		return path;
	}

	/**
     * `IuWFNgԂB
     * `݂Ȃꍇ null ԂB
     * 
     * @param ename GW
     * @param path pX
     * @return `IuWFNg
	 * @throws Exception Cӂ̗O
	 */
	private PackageDefinition getDefinition(String ename, String path)
	throws Exception
	{
		PackageDefinition def = (PackageDefinition)definitionMap.get(path);
		
		if (def == null) {
			DefinitionLoader loader = DefinitionLoader.getInstance();
			def = loader.getDefinition(ename, path);
		}
		return def;
	}
}
