/* $Id: ProcessDefinitionFlowPanel.java,v 1.8 2005/08/26 04:45:51 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;

/**
 * vZX`t[\p̃plłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDefinitionFlowPanel extends JPanel
{
	/** c[o[ */
	private JToolBar toolbar;
	/** GWr[t[ */
	private EngineViewFrame frame;
	/** t[\GA */
	private ProcessDefinitionFlowView view;
	/** vZX` */
	private ProcDef procDef;
	/** pbP[W` */
	private PackageDefinition packageDefinition;
	
	/**
	 * vZX`t[\p̃pl𐶐B
	 *
	 * @param isDoubleBuffered
	 */
	public ProcessDefinitionFlowPanel(EngineViewFrame frame, ProcDef pd, PackageDefinition def)
	{
		super(new BorderLayout(), true);
		
		this.frame = frame;
		this.procDef = pd;
		this.packageDefinition = def;
		
		createFlowView();
		createToolBar();
	}
	
	/**
	 * vZX`Ԃ܂B
	 *
	 * @return
	 */
	String getProcessDefinitionName()
	{
		return procDef.getID();
	}
	
	/**
	 * c[o[쐬܂B
	 */
	private void createToolBar()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		toolbar = new JToolBar(JToolBar.VERTICAL);
		toolbar.setFloatable(false);

		Icon icon = IconManager.getIcon("property");
		JButton propButton = new JButton();
		propButton.setIcon(icon);
		propButton.setToolTipText(rm.getResource("ProcessDefinitionFlowPanel.toolbar.label.0"));
		propButton.addActionListener(new ShowPropertyAction());

		toolbar.add(propButton);

		add(toolbar, BorderLayout.WEST);
	}

	/**
	 * t[\GA쐬܂B
	 */
	private void createFlowView()
	{
		int index = getProcessDefinitionIndex();
		List procs = packageDefinition.getProcesses();
		ProcessDefinition def = (ProcessDefinition)procs.get(index);
		view = new ProcessDefinitionFlowView(def);
		JScrollPane sp = new JScrollPane(view);
		add(sp, BorderLayout.CENTER);
	}

	/**
	 * ANeBreB`̃vpeB쐬ĕԂB
	 *
	 * @param rm \[X}l[W
	 * @param act ANeBreB`
	 * @return vpeB
	 */
	private Properties getProperties(ResourceManager rm, ActivityDefinition act)
	{
		Properties prop = new Properties();
		
		prop.put(rm.getResource("ActivityDefinition.key.0"),  "" + act.getAffiliateBID());
		prop.put(rm.getResource("ActivityDefinition.key.1"),  "" + act.getApplicationID());
		prop.put(rm.getResource("ActivityDefinition.key.2"),  "" + act.getBlockID());
		prop.put(rm.getResource("ActivityDefinition.key.3"),  "" + act.getDescription());
		prop.put(rm.getResource("ActivityDefinition.key.4"),  "" + act.getEngineName());
		prop.put(rm.getResource("ActivityDefinition.key.5"),  "" + act.getID());
		prop.put(rm.getResource("ActivityDefinition.key.6"),  "" + act.getName());
		prop.put(rm.getResource("ActivityDefinition.key.7"),  "" + act.getParentBID());
		prop.put(rm.getResource("ActivityDefinition.key.8"),  "" + act.getPerformerID());
		prop.put(rm.getResource("ActivityDefinition.key.9"),  "" + act.getSubprocessID());
		prop.put(rm.getResource("ActivityDefinition.key.10"), "" + act.getType());
		prop.put(rm.getResource("ActivityDefinition.key.11"), "" + act.getExecution());
		prop.put(rm.getResource("ActivityDefinition.key.12"), "" + act.getLimit());
		prop.put(rm.getResource("ActivityDefinition.key.13"), "" + act.getLogicalX());
		prop.put(rm.getResource("ActivityDefinition.key.14"), "" + act.getLogicalY());
		
		return prop;
	}
	
	/**
	 * vZX`̃CfNXԍԂB
	 *
	 * @return CfNXԍ
	 */
	private int getProcessDefinitionIndex()
	{
		String pdid = procDef.getID();
		
		int begin = pdid.lastIndexOf('-') + 1;
		int end = pdid.length();
		String indexString = pdid.substring(begin, end);
		int index = Integer.parseInt(indexString);
		return index;
	}
	
	/**
	 * ANeBreBvf̑Jڏ擾B
	 * 
	 * @param act ANeBreBvf
	 * @return Jڏ
	 */
	private List getTransitions(ActivityDefinition act)
	{
		List trs = new ArrayList();
		if (act == null) return trs;

		int index = getProcessDefinitionIndex();
		List procs = packageDefinition.getProcesses();
		ProcessDefinition proc = (ProcessDefinition)procs.get(index);
		Iterator tit = proc.getTransitions().iterator();
		while (tit.hasNext()) {
			TransitionDefinition t = (TransitionDefinition)tit.next();
			if (act == t.getSource()) {
				trs.add(t);
			}
		}
		return trs;
	}
	
	/**
	 * vpeB\ANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ShowPropertyAction implements ActionListener
	{
		/**
		 * vpeB\B
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition act = view.getSelectedActivity();
			if (act == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}

			Properties prop = getProperties(rm, act);
			List trs = getTransitions(act);
			List vars = packageDefinition.getVariables();
			//PropertyDialog.showDialog(ProcessDefinitionFlowPanel.this, act.getName(), prop);
			ActivityDefinitionPropertyDialog.showDialog(
					ProcessDefinitionFlowPanel.this, act.getName(), prop, trs, vars);
		}
	}
}
