/* $Id: ProcessDefinitionFlowView.java,v 1.8 2005/08/26 04:45:43 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.List;

import javax.swing.Icon;
import javax.swing.JComponent;

import jp.co.argo21.commons.swing.Grid;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;

/**
 * vZX`̃t[\GAłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDefinitionFlowView
extends JComponent
implements MouseListener, MouseMotionListener
{
	/** Obh\萔 */
	static public final int GRID_SIZE           = 80;
	/** ACRTCY\萔 */
	static private final int MAX_ICON_SIZE      = 48;
	/** @\萔 */
	static private final int INSET_SIZE         = 9;
	/** ŏ_Pʐ\萔 */
	static private final int MIN_LOGICAL_WIDTH  = 10;
	/** ŏ_Pʐ\萔 */
	static private final int MIN_LOGICAL_HEIGHT = 10;

	/** wiF */
	static private final Color BACKGROUND        = new Color(255, 255, 230);
	/** C[̔wiF */
	static private final Color LAYER_BACKGROUND  = new Color(230, 255, 255, 64);

	/** `ɎgptHg */
	static private final Font VIEW_FONT = new Font("MonoSpaced", Font.PLAIN, 10);

	/** p`pX */
	static private GeneralPath ARROW_PATH;

	/** J[\ʒű`W */
	private Rectangle cursorRect;
	/** I𒆂̋`W */
	private Rectangle selectedRect;

	/** ΏۂƂȂvZX */
	private ProcessDefinition proc;

	/** I𒆂ActivityDefinition */
	private ActivityDefinition selectedActivity;

	/** KwǗ郊Xg */
	private ConcurrentLayerManager root;

	/**
	 * p`pX̏
	 */
	static
	{
		// p`pX̏
		ARROW_PATH = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
		ARROW_PATH.moveTo(0, 0);
		ARROW_PATH.lineTo(15, 5);
		ARROW_PATH.lineTo(15, -5);
		ARROW_PATH.closePath();
	}

	/**
	 * vZX`̃t[\GA𐶐B
	 * 
	 * @param proc ΏۂƂȂvZX`
	 */
	public ProcessDefinitionFlowView(ProcessDefinition proc)
	{
		this.proc = proc;
		int w = proc.getLogicalWidth();
		int h = proc.getLogicalHeight();

		if (w < MIN_LOGICAL_WIDTH) {
			w = MIN_LOGICAL_WIDTH;
		} 
		if (h < MIN_LOGICAL_HEIGHT) {
			h = MIN_LOGICAL_HEIGHT;
		} 
		
		Dimension size = new Dimension(GRID_SIZE * w + 1, GRID_SIZE * h + 1);
		
		root = new ConcurrentLayerManager();
		root.initConcurrentLayer(proc.getActivities());
			
		setPreferredSize(size);
		setMinimumSize(size);
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	/**
	 * t[\GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Shape clip = g.getClip();

		Dimension size = this.getSize();

		//`͈͈ȊO̔wi̕`
		g.setColor(Color.gray);
		g.fillRect(0, 0, size.width, size.height);

		Dimension psize = this.getPreferredSize();

		//`͈͂̔wi̕`
		g.setColor(BACKGROUND);
		g.fillRect(0, 0, psize.width, psize.height);

		//C[̔wi`
		root.paintLayerBackgroud(g, LAYER_BACKGROUND, GRID_SIZE);

		//I𒆂̃ANeBreB̕`
		if (selectedActivity != null) {
			paintActivityBackground(g, Color.pink, selectedActivity);
		}

		//r[̕`
		paintView(g);
						
		//J[\`̕`
		if (cursorRect != null) {
			g.drawRect(cursorRect.x, cursorRect.y, cursorRect.width, cursorRect.height);
		}

		//C[̘g`
		root.paintLayerBorder(g, Color.blue, GRID_SIZE);

		//I𒆂̃ANeBreB̕`
		if (selectedRect != null) {
			g.setColor(Color.red);
			g.drawRect(selectedRect.x, selectedRect.y, selectedRect.width, selectedRect.height);
		}

		g.setClip(clip);
		g.dispose();
	}

	/**
	 * t[\GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintView(Graphics g)
	{
		Shape clip = g.getClip();

		g.setFont(VIEW_FONT);

		Dimension psize = this.getPreferredSize();

		//`͈͂̃Obh̕`
		Grid.draw(new Rectangle(psize), g, GRID_SIZE);
		g.clipRect(0, 0, psize.width, psize.height);

		g.setColor(Color.black);
			
		//ANeBreB̕`
		List acts = proc.getActivities();
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)ait.next();
			paintActivity(g, act);
		}
			
		//Jڂ̕`
		List trs = proc.getTransitions();
		Iterator tit = trs.iterator();
		while (tit.hasNext()) {
			TransitionDefinition tr = (TransitionDefinition)tit.next();
			paintTransition(g, Color.black, tr.getSource(), tr.getDestination());
		}

		g.setClip(clip);
	}

	/**
	 * w肳ꂽANeBreBwi`悷B
	 * 
	 * @param g   `ΏۃOtBbNX
	 * @param c   `F
	 * @param act ANeBreB
	 */
	private void paintActivityBackground(Graphics g, Color c, ActivityDefinition act)
	{
		if (act == null) return;

		int ax = act.getLogicalX();
		int ay = act.getLogicalY();

		int x = GRID_SIZE * ax;
		int y = GRID_SIZE * ay;
		int w = GRID_SIZE;
		int h = GRID_SIZE;

		g.setColor(c);
		g.fillRect(x, y, w, h);
	}

	/**
	 * w肳ꂽANeBreB`悷B
	 * 
	 * @param g  `ΏۃOtBbNX
	 * @param act ANeBreB
	 */
	private void paintActivity(Graphics g, ActivityDefinition act)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		String name = act.getName();
		if (StringUtils.checkNull(name)) {
			name = rm.getResource("ProcessDefinitionFlowView.noname");
		} 

		//ANeBreBACR̕`
		String type = act.getType();
		String iconName = getIconName(type);
		Icon icon = IconManager.getIcon(iconName);

		int ax = act.getLogicalX();
		int ay = act.getLogicalY();

		int x = GRID_SIZE * ax;
		int y = GRID_SIZE * ay;
		int w = GRID_SIZE;
		int h = GRID_SIZE;

		int iconW = icon.getIconWidth();
		int iconH = icon.getIconHeight();
		int iconX = x + ((w - iconW) / 2);
		int iconY = y + 9;
		icon.paintIcon(this, g, iconX, iconY);

		//ANeBreB̕`
		FontMetrics metrics = g.getFontMetrics();
		int fontH = metrics.getHeight();
		int descent = metrics.getDescent();
		int lineW = metrics.stringWidth(name);
		int dx = x + ((w - lineW) / 2);
		int dy = y + 9 + iconH;
		if (dx < 0) dx = 0;
		dy = dy + fontH - descent;
		g.setColor(SystemColor.textText);
		g.drawString(name, dx, dy);
	}

	/**
	 * w肳ꂽANeBreBԂ̑Jڂ`悷B
	 * 
	 * @param g   `ΏۃOtBbNX
	 * @param c   `F
	 * @param src JڌANeBreB
	 * @param dst JڐANeBreB
	 */
	private void paintTransition(Graphics g, Color c, ActivityDefinition src, ActivityDefinition dst)
	{
		if (src == null) return;
		if (dst == null) return;

		int sx = src.getLogicalX();
		int sy = src.getLogicalY();
		int dx = dst.getLogicalX();
		int dy = dst.getLogicalY();

		Point sp = getSourcePoint(sx, sy, dx, dy);
		Point dp = getDestinationPoint(sx, sy, dx, dy);

		//Jڐ̕`
		paintArrowLine(g, c, sp.x, sp.y, dp.x, dp.y);
	}

	/**
	 * `悷B
	 *
	 * @param g  `ΏۃOtBbNX
	 * @param c  `F
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 */
	private void paintArrowLine(Graphics g, Color c, int sx, int sy, int dx, int dy)
	{
		Graphics2D g2 = (Graphics2D)g;

		//݂̍Wϊsۑ
		AffineTransform tr = g2.getTransform();

		g2.setColor(c);
		g2.drawLine(sx, sy, dx, dy);

		//`
		g2.translate(dx, dy);
		double theta = Math.atan2(((double)(sy - dy)), ((double)(sx - dx)));
		g2.rotate(theta);
		g2.fill(ARROW_PATH);
		g2.draw(ARROW_PATH);

		g2.setTransform(tr);
	}

	/**
	 * ڑ̕`Jn_ZoB
	 *
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 * @return `Jn_
	 */
	private Point getSourcePoint(int sx, int sy, int dx, int dy)
	{
		int x = (sx * GRID_SIZE) + (GRID_SIZE / 2);
		int y = (sy * GRID_SIZE) + (GRID_SIZE / 2);
		if (sx < dx) {
			x = (sx * GRID_SIZE) + (GRID_SIZE - ((GRID_SIZE - MAX_ICON_SIZE) / 2));
			y = (sy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else if (sx > dx) {
			x = (sx * GRID_SIZE) + ((GRID_SIZE - MAX_ICON_SIZE) / 2);
			y = (sy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else {
			if (sy < dy) {
				y = (sy * GRID_SIZE) + GRID_SIZE - INSET_SIZE;
			} else if (sy > dy) {
				y = (sy * GRID_SIZE) + INSET_SIZE;
			}
		}
		return new Point(x, y);
	}

	/**
	 * ڑ̕`I_ZoB
	 *
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 * @return `I_
	 */
	private Point getDestinationPoint(int sx, int sy, int dx, int dy)
	{
		int x = (dx * GRID_SIZE) + (GRID_SIZE / 2);
		int y = (dy * GRID_SIZE) + (GRID_SIZE / 2);
		if (sx < dx) {
			x = (dx * GRID_SIZE) + ((GRID_SIZE - MAX_ICON_SIZE) / 2);
			y = (dy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else if (sx > dx) {
			x = (dx * GRID_SIZE) + (GRID_SIZE - ((GRID_SIZE - MAX_ICON_SIZE) / 2));
			y = (dy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else {
			if (sy < dy) {
				y = (dy * GRID_SIZE) + INSET_SIZE;
			} else if (sy > dy) {
				y = (dy * GRID_SIZE) + GRID_SIZE - INSET_SIZE;
			}
		}
		return new Point(x, y);
	}
	/**
	 * }EXJ[\̍WANeBreB肷B
	 * 
	 * @param mx }EXXW
	 * @param my }EXYW
	 * @return ANeBreB
	 */
	private ActivityDefinition getActivity(int mx, int my)
	{
		int lx = mx / GRID_SIZE;
		int ly = my / GRID_SIZE;

		List acts = proc.getActivities();
		Iterator it = acts.iterator();
		while (it.hasNext()) {
			ActivityDefinition act = (ActivityDefinition)it.next();
			int x = act.getLogicalX();
			int y = act.getLogicalY();
			if (x == lx && y == ly) {
				return act;
			}
		}
		return null;
	}

	/**
	 * w肳ꂽANeBreBIԂɂB
	 * 
	 * @param act	ANeBreB
	 */
	public void setSelectedActivity(ActivityDefinition act)
	{
		selectedActivity = act;
	}
	
	/**
	 * ANeBreB^ACRԂB
	 *
	 * @param type ^
	 * @return ACR
	 */
	private String getIconName(String type)
	{
		String iconName = null;
		
		if (type.equals(ActivityDefinition.START))             iconName = "start";
		else if (type.equals(ActivityDefinition.INTERACTIVE))  iconName = "interactive";
		else if (type.equals(ActivityDefinition.AUTOMATIC))    iconName = "automatic";
		else if (type.equals(ActivityDefinition.SUBPROCESS))   iconName = "subprocess";
		else if (type.equals(ActivityDefinition.CONCUR_START)) iconName = "concurrent-start";
		else if (type.equals(ActivityDefinition.CONCUR_END))   iconName = "concurrent-end";
		else if (type.equals(ActivityDefinition.END))          iconName = "end";
		
		return iconName;
	}

	/**
	 * IĂANeBreBԂB
	 * 
	 * @return	ANeBreB
	 */
	public ActivityDefinition getSelectedActivity()
	{
		return selectedActivity;
	}

	/**
	 * }EXNbN𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e)
	{
		int mx = e.getX();
		int my = e.getY();
		int lx = mx / GRID_SIZE;
		int ly = my / GRID_SIZE;

		if (selectedRect == null) {
			selectedRect = new Rectangle(GRID_SIZE, GRID_SIZE);
		} 
		selectedRect.x = lx * GRID_SIZE;
		selectedRect.y = ly * GRID_SIZE;
		
		setSelectedActivity(getActivity(mx, my));

		repaint();
	}

	/**
	 * }EX𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e)
	{
	}

	/**
	 * }EX̉𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e)
	{
	}

	/**
	 * }EX̐N𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e)
	{
	}

	/**
	 * }EX̒Eo𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e)
	{
		cursorRect = null;
		repaint();
	}

	/**
	 * }EXhbO𔻒肷B
	 *
	 * @param	e		}EXCxg
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e)
	{
		mouseMoved(e);
	}

	/**
	 * }EXړ𔻒肷B
	 *
	 * @param	e		}EXCxg
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e)
	{
		int mx = e.getX();
		int my = e.getY();

		Dimension psize = ProcessDefinitionFlowView.this.getPreferredSize();

		if ((mx >= psize.width) || (my >= psize.height)) {
			cursorRect = null;
			repaint();
			return;
		}
		int lx = mx / GRID_SIZE;
		int ly = my / GRID_SIZE;
				
		if (cursorRect == null) {
			cursorRect = new Rectangle(GRID_SIZE, GRID_SIZE);
		} 
		cursorRect.x = lx * GRID_SIZE;
		cursorRect.y = ly * GRID_SIZE;

		repaint();
	}
}
