/* $Id: ProcessDefinitionNode.java,v 1.6 2005/08/26 04:45:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import javax.swing.tree.TreeNode;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;

/**
 * GWr[̃vZXc[̃ZJhm[hłB
 * qm[hƂăvZXm[hB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDefinitionNode implements EngineTreeNode
{
	/** L[vtBbNX */
	static public final String PDID = "pdid:";
	

	/** em[h */
	private EngineNode parentNode;
	
	/** vZX` */
	private ProcDef procDef;

	/** qm[h̔z */
	private Vector children;
	
	/** ftHg̃tB^[ */
	private Filter defaultFilter;
	
	/** ݐݒ蒆̃tB^[ */
	private Filter currentFilter;

	/**
	 * vZX`m[h𐶐B
	 */
	public ProcessDefinitionNode(EngineNode parent, ProcDef def)
	{
		parentNode = parent;
		procDef = def;
		children = new Vector();
		String fs = PDID + procDef.getID();
		defaultFilter = new NameFilter(fs, NameFilter.EQUAL);
		currentFilter = defaultFilter;
	}

	/**
	 * qm[hEnumerationŕԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration children()
	{
		return children.elements();
	}

	/**
	 * qm[h󂯓邩ǂԂB
	 *
	 * @return l
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren()
	{
		return false;
	}

	/**
	 * CfNXŎw肳ꂽqm[hԂB
	 *
	 * @param childIndex CfNX
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int childIndex)
	{
		return (TreeNode)children.get(childIndex);
	}

	/**
	 * qm[h̐ԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount()
	{
		return children.size();
	}

	/**
	 * w肳ꂽm[h̃CfNXlԂB
	 *
	 * @param node m[h
	 * @return CfNX
	 * @see javax.swing.tree.TreeNode#getIndex(javax.swing.tree.TreeNode)
	 */
	public int getIndex(TreeNode node)
	{
		return children.indexOf(node);
	}
	
	/**
	 * em[hԂB
	 *
	 * @return em[h
	 * @see javax.swing.tree.TreeNode#getParent()
	 */
	public TreeNode getParent()
	{
		return parentNode;
	}

	/**
	 * [m[hǂԂB
	 *
	 * @return [m[hȂtrue
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf()
	{
		return false;
	}
	
	/**
	 * m[hԂB
	 *
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return procDef.getID();
	}
	
	/**
	 * m[h̏XVB
	 *
	 * @param filter
	 * @throws Exception
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#reload(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void reload(Filter filter) throws Exception
	{
		if (filter != null) {
			if (filter instanceof GroupFilter) {
				Filter[] sub = ((GroupFilter)filter).getChild();
				sub[0] = defaultFilter;
			}
			currentFilter = filter;
		} else {
			currentFilter = defaultFilter;
		}
		
		EngineViewFrame frame = getFrame();
		EngineViewController evc = frame.getEngineViewController();
		Process[] procs = evc.getProcess(currentFilter);
		children.clear();
		for (int i = 0; i < procs.length; i++) {
			ProcessNode child = new ProcessNode(this, procs[i]);
			children.add(child);
		}
	}
	
	/**
	 * m[h̃vpeBԂB
	 *
	 * @param rm \[X}l[W
	 * @return vpeB
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#getProperties()
	 */
	public Properties getProperties(ResourceManager rm)
	{
		Properties prop = new Properties();

		String name = procDef.getName();
		if (name == null) name = "";
		ProcessDefinitionState state = procDef.getState();
		String stateString = null;
		String stateInt = null;
		if (state == null) {
			stateString = "";
			stateInt = "";
		} else {
			stateString = state.toString();
			stateInt = "" + state.toInt();
		}
		prop.put(rm.getResource("ProcessDefinitionNode.key.0"), procDef.getID());
		prop.put(rm.getResource("ProcessDefinitionNode.key.1"), name);
		prop.put(rm.getResource("ProcessDefinitionNode.key.2"), stateString);
		prop.put(rm.getResource("ProcessDefinitionNode.key.3"), stateInt);

		return prop;
	}
	
	/**
	 * vZX`ԂB
	 *
	 * @return vZX`
	 */
	public ProcDef getProcDef()
	{
		return procDef;
	}

	/**
	 * GWr[t[ԂB
	 *
	 * @return GWr[t[
	 */
	EngineViewFrame getFrame()
	{
		return parentNode.getFrame();
	}
}
