/* $Id: ProcessFlowPanel.java,v 1.8 2005/08/26 04:45:48 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.common.PropertyDialog;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * vZXt[\p̃plłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessFlowPanel extends JPanel
{
	/** c[o[ */
	private JToolBar toolbar;
	/** GWr[t[ */
	private EngineViewFrame frame;
	/** t[\GA */
	private ProcessFlowView view;
	/** vZX */
	private Process process;
	/** pbP[W */
	private PackageDefinition packageDefinition;
	
	/**
	 * vZXt[\p̃pl𐶐B
	 *
	 * @param isDoubleBuffered
	 */
	public ProcessFlowPanel(EngineViewFrame frame, Process proc, PackageDefinition def)
	{
		super(new BorderLayout(), true);
		
		this.frame = frame;
		this.process = proc;
		this.packageDefinition = def;
		
		createFlowView();
		createToolBar();
	}
	
	/**
	 * vZXIDԂ܂B
	 *
	 * @return vZXID
	 */
	String getProcessID()
	{
		return process.getID();
	}
	
	/**
	 * c[o[쐬܂B
	 */
	private void createToolBar()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		toolbar = new JToolBar(JToolBar.VERTICAL);
		toolbar.setFloatable(false);

		Icon icon0 = IconManager.getIcon("property");
		JButton propButton = new JButton();
		propButton.setIcon(icon0);
		propButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.0"));
		propButton.addActionListener(new ShowPropertyAction());

		Icon icon1 = IconManager.getIcon("varlist");
		JButton varlistButton = new JButton();
		varlistButton.setIcon(icon1);
		varlistButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.1"));
		varlistButton.addActionListener(new ShowAttributeListAction());

		Icon icon2 = IconManager.getIcon("reload");
		JButton reloadButton = new JButton();
		reloadButton.setIcon(icon2);
		reloadButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.2"));
		reloadButton.addActionListener(new ReloadAction());

		Icon icon3 = IconManager.getIcon("suspend");
		JButton suspendButton = new JButton();
		suspendButton.setIcon(icon3);
		suspendButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.3"));
		suspendButton.addActionListener(new SuspendActivityAction());

		Icon icon4 = IconManager.getIcon("resume");
		JButton resumeButton = new JButton();
		resumeButton.setIcon(icon4);
		resumeButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.4"));
		resumeButton.addActionListener(new ResumeActivityAction());

		Icon icon5 = IconManager.getIcon("complete");
		JButton completeButton = new JButton();
		completeButton.setIcon(icon5);
		completeButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.5"));
		completeButton.addActionListener(new CompleteActivityAction());

		Icon icon6 = IconManager.getIcon("abort");
		JButton abortButton = new JButton();
		abortButton.setIcon(icon6);
		abortButton.setToolTipText(rm.getResource("ProcessFlowPanel.toolbar.label.6"));
		abortButton.addActionListener(new AbortProcessAction());

		toolbar.add(propButton);
		toolbar.add(varlistButton);
		toolbar.add(reloadButton);
		toolbar.addSeparator();
		toolbar.add(suspendButton);
		toolbar.add(resumeButton);
		toolbar.addSeparator();
		toolbar.add(completeButton);
		toolbar.add(abortButton);

		add(toolbar, BorderLayout.WEST);
	}

	/**
	 * t[\GA쐬܂B
	 */
	private void createFlowView()
	{
		EngineViewController evc = frame.getEngineViewController();
		int index = getProcessDefinitionIndex();
		List procs = packageDefinition.getProcesses();
		ProcessDefinition def = (ProcessDefinition)procs.get(index);
		view = new ProcessFlowView(evc, def, process);
		JScrollPane sp = new JScrollPane(view);
		add(sp, BorderLayout.CENTER);
	}

	/**
	 * ANeBreB`̃vpeB쐬ĕԂB
	 *
	 * @param rm \[X}l[W
	 * @param act ANeBreB`
	 * @return vpeB
	 */
	private Properties getProperties(ResourceManager rm, ActivityDefinition act)
	{
		Properties prop = new Properties();
		
		prop.put(rm.getResource("ActivityDefinition.key.0"),  "" + act.getAffiliateBID());
		prop.put(rm.getResource("ActivityDefinition.key.1"),  "" + act.getApplicationID());
		prop.put(rm.getResource("ActivityDefinition.key.2"),  "" + act.getBlockID());
		prop.put(rm.getResource("ActivityDefinition.key.3"),  "" + act.getDescription());
		prop.put(rm.getResource("ActivityDefinition.key.4"),  "" + act.getEngineName());
		prop.put(rm.getResource("ActivityDefinition.key.5"),  "" + act.getID());
		prop.put(rm.getResource("ActivityDefinition.key.6"),  "" + act.getName());
		prop.put(rm.getResource("ActivityDefinition.key.7"),  "" + act.getParentBID());
		prop.put(rm.getResource("ActivityDefinition.key.8"),  "" + act.getPerformerID());
		prop.put(rm.getResource("ActivityDefinition.key.9"),  "" + act.getSubprocessID());
		prop.put(rm.getResource("ActivityDefinition.key.10"), "" + act.getType());
		prop.put(rm.getResource("ActivityDefinition.key.11"), "" + act.getExecution());
		prop.put(rm.getResource("ActivityDefinition.key.12"), "" + act.getLimit());
		prop.put(rm.getResource("ActivityDefinition.key.13"), "" + act.getLogicalX());
		prop.put(rm.getResource("ActivityDefinition.key.14"), "" + act.getLogicalY());
		
		return prop;
	}

	/**
	 * ANeBreB̃vpeB쐬ĕԂB
	 *
	 * @param rm \[X}l[W
	 * @param act ANeBreB
	 * @return vpeB
	 */
	private Properties getProperties(ResourceManager rm, Activity act)
	{
		Properties prop = new Properties();
		
		prop.put(rm.getResource("Activity.key.0"),  "" + act.getActivityDefinitionID());
		prop.put(rm.getResource("Activity.key.1"),  "" + act.getActivityID());
		prop.put(rm.getResource("Activity.key.2"),  "" + act.getActivityState());
		prop.put(rm.getResource("Activity.key.3"),  "" + act.getActorID());
		prop.put(rm.getResource("Activity.key.4"),  "" + act.getBlockID());
		prop.put(rm.getResource("Activity.key.5"),  "" + act.getName());
		prop.put(rm.getResource("Activity.key.6"),  "" + act.getProcessID());
		prop.put(rm.getResource("Activity.key.7"),  "" + act.getStarterID());
		prop.put(rm.getResource("Activity.key.8"),  "" + act.getDurationLimit());
		prop.put(rm.getResource("Activity.key.9"),  "" + act.getStartDate());
		prop.put(rm.getResource("Activity.key.10"), "" + act.getUpdateDate());
		
		return prop;
	}
	
	/**
	 * vZX̃CfNXԍԂB
	 *
	 * @return CfNXԍ
	 */
	private int getProcessDefinitionIndex()
	{
		String pdid = process.getProcDefinitionID();
		
		int begin = pdid.lastIndexOf('-') + 1;
		int end = pdid.length();
		String indexString = pdid.substring(begin, end);
		int index = Integer.parseInt(indexString);
		return index;
	}
	
	/**
	 * vpeB\ANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ShowPropertyAction implements ActionListener
	{
		/**
		 * vpeB\B
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition actdef = view.getSelectedActivity();
			if (actdef == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}

			Map props = new Hashtable();
			String adid = actdef.getID();
			String adname = actdef.getName();
			List acts = view.getActivitiesByDefinitionID(adid);
			if (acts.size() == 0) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}
			
			Iterator it = acts.iterator();
			while (it.hasNext()) {
				Activity act = (Activity)it.next();
				String aname = act.getActivityID();
				Properties actprop = getProperties(rm, act);
				props.put(aname, actprop);
			}

			PropertyDialog.showDialog(ProcessFlowPanel.this, adname, props);
		}
	}
	
	/**
	 * vZXϐ\ANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ShowAttributeListAction implements ActionListener
	{
		/**
		 * vZXϐ\B
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;

			GetAttributeTask gvtask = new GetAttributeTask();
			WorkflowAdminManager.runBusyTask(gvtask);

			List list = gvtask.getAttributes();
			if (list == null || list.size() == 0) {
				ResourceManager rm = WorkflowAdminManager.getResourceManager();
				DialogUtilities.showInfo(rm.getResource("I9003"));
				return;
			}
			AttributeDialog dialog = new AttributeDialog();
			dialog.setAttributes(list);
			dialog.setVisible(true);
			int result = dialog.getResult();
			if (result == AttributeDialog.END_OPTION) {
				return;
			}
			List updatedList = dialog.getUpdatedAttributes();
			dialog.dispose();

			if (updatedList == null || updatedList.size() == 0) {
				ResourceManager rm = WorkflowAdminManager.getResourceManager();
				DialogUtilities.showInfo(rm.getResource("I9005"));
				return;
			}

			SetAttributeTask svtask = new SetAttributeTask(updatedList);
			WorkflowAdminManager.runBusyTask(svtask);
		}
	}
	
	/**
	 * t[̍ĕ\sANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ReloadAction implements ActionListener
	{
		/**
		 * t[̍ĕ\sB
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			
			view.reload();
		}
	}
	
	/**
	 * ANeBreBԂɂANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class CompleteActivityAction implements ActionListener
	{
		/**
		 * ANeBreBԂɂB
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition actdef = view.getSelectedActivity();
			if (actdef == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}
			String adid = actdef.getID();
			Activity act = view.getActivityByDefinitionID(adid);
			
			if (act == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}

			int st = act.getActivityState();
			if (st == ActivityState.CLOSED_COMPLETED.toInt()
					|| st == ActivityState.CLOSED_TERMINATED.toInt()
					|| st == ActivityState.CLOSED_ABORTED.toInt()) {
				DialogUtilities.showError(rm.getResource("E9031"));
				return;
			}
			
			String pid = process.getID();
			String aid = act.getActivityID();
			BusyTask task = new ChangeActivityStateTask(pid, aid, ActivityState.CLOSED_COMPLETED);
			WorkflowAdminManager.runBusyTask(task);
			
			view.reload();
		}
	}
	
	/**
	 * ANeBreBۗԂɂANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class SuspendActivityAction implements ActionListener
	{
		/**
		 * ANeBreBۗԂɂB
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition actdef = view.getSelectedActivity();
			if (actdef == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}
			String adid = actdef.getID();
			Activity act = view.getActivityByDefinitionID(adid);
			
			if (act == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}

			int st = act.getActivityState();
			if (st != ActivityState.OPEN_RUNNING.toInt()) {
				DialogUtilities.showError(rm.getResource("E9028"));
				return;
			}
			
			String pid = process.getID();
			String aid = act.getActivityID();
			BusyTask task = new ChangeActivityStateTask(pid, aid, ActivityState.OPEN_NOT_RUNNING_SUSPENDED);
			WorkflowAdminManager.runBusyTask(task);
			
			view.reload();
		}
	}
	
	/**
	 * ANeBreBĊJANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ResumeActivityAction implements ActionListener
	{
		/**
		 * ANeBreBĊJB
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition actdef = view.getSelectedActivity();
			if (actdef == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}
			String adid = actdef.getID();
			Activity act = view.getActivityByDefinitionID(adid);
			
			if (act == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}
			
			int st = act.getActivityState();
			if (st != ActivityState.OPEN_NOT_RUNNING_SUSPENDED.toInt()) {
				DialogUtilities.showError(rm.getResource("E9030"));
				return;
			}

			String pid = process.getID();
			String aid = act.getActivityID();
			BusyTask task = new ChangeActivityStateTask(pid, aid, ActivityState.OPEN_RUNNING);
			WorkflowAdminManager.runBusyTask(task);
			
			view.reload();
		}
	}
	
	/**
	 * vZXIANVB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class AbortProcessAction
	implements ActionListener, BusyTask
	{
		/**  */
		private int state = INIT;
		
		/**
		 * vZXIB
		 *
		 * @param e Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			if (process == null) return;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			
			int st = process.getProcessState();
			if (st == ProcessState.CLOSED_COMPLETED.toInt()
					|| st == ProcessState.CLOSED_TERMINATED.toInt()
					|| st == ProcessState.CLOSED_ABORTED.toInt()) {
				DialogUtilities.showError(rm.getResource("E9026"));
				return;
			}

			int ret = DialogUtilities.showYesNoConfirm(rm.getResource("I9004"));
			if (ret == JOptionPane.NO_OPTION) return;

			WorkflowAdminManager.runBusyTask(this);
			
			view.reload();
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * vZXIB
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			String pid = process.getID();
			try {
				EngineViewController evc = frame.getEngineViewController();
				evc.changeProcessState(pid, ProcessState.CLOSED_ABORTED);
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9027") + "(" + pid + ")");
			} finally {
				state = COMPLETE;
			}
		}
	}
	
	/**
	 * vZXϐ擾p^XNB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class GetAttributeTask implements BusyTask
	{
		/**  */
		private int state = INIT;
		/** vZXϐꗗ */
		private List attributes;
		
		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * vZXϐ擾B
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			String pid = process.getID();
			try {
				EngineViewController evc = frame.getEngineViewController();
				attributes = evc.getProcessAttributes(pid, null);
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9027"));
			} finally {
				state = COMPLETE;
			}
		}
		
		/**
		 * vZXϐԂB
		 *
		 * @return vZXϐ
		 */
		private List getAttributes()
		{
			return attributes;
		}
	}
	
	/**
	 * vZXϐݒp^XNB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class SetAttributeTask implements BusyTask
	{
		/**  */
		private int state = INIT;
		/** vZXϐꗗ */
		private List attributes;
		
		/**
		 * vZXϐݒp^XN𐶐B
		 *
		 * @param attributes vZXϐꗗ
		 */
		public SetAttributeTask(List attributes)
		{
			this.attributes = attributes;
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * vZXϐݒ肷B
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			String pid = process.getID();
			try {
				EngineViewController evc = frame.getEngineViewController();
				evc.setProcessAttributes(pid, attributes);
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9032"));
			} finally {
				state = COMPLETE;
			}
		}
	}
	
	/**
	 * ANeBreB̏ԂύX鏈B
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.8 $
	 * @since   Nautica Workflow 0.9
	 */
	private class ChangeActivityStateTask implements BusyTask
	{
		/**  */
		private int state = INIT;
		
		/** ΏۃvZXID */
		private String pid;
		/** ΏۃANeBreBID */
		private String aid;
		/** ΏۃANeBreB */
		private ActivityState astate;

		/**
		 * ANeBreB̏ԂύX鏈𐶐B
		 *
		 * @param pid vZXID
		 * @param aid ANeBreBID
		 * @param astate ANeBreB
		 */
		private ChangeActivityStateTask(String pid, String aid, ActivityState astate)
		{
			this.pid = pid;
			this.aid = aid;
			this.astate = astate;
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * ANeBreB̏ԂύXB
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			try {
				if (aid == null) return;
				EngineViewController evc = frame.getEngineViewController();
				evc.changeActivityState(pid, aid, astate);
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9029") + "(" + pid + "/" + aid + ")");
			} finally {
				aid = null;
				state = COMPLETE;
			}
		}
	}
}
