/* $Id: ProcessNode.java,v 1.7 2005/08/26 04:45:42 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;

import javax.swing.tree.TreeNode;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * GWr[̃vZXc[̖[m[hłB
 * vZX`m[hzɃ}bvB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessNode implements EngineTreeNode
{
	/** em[h */
	private ProcessDefinitionNode parentNode;

	/** vZX */
	private Process process;

	/**
	 * vZXm[h𐶐B
	 */
	public ProcessNode(ProcessDefinitionNode parent, Process proc)
	{
		parentNode = parent;
		process = proc;
	}

	/**
	 * qm[hEnumerationŕԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration children()
	{
		return null;
	}

	/**
	 * qm[h󂯓邩ǂԂB
	 *
	 * @return l
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren()
	{
		return false;
	}

	/**
	 * CfNXŎw肳ꂽqm[hԂB
	 *
	 * @param childIndex CfNX
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int childIndex)
	{
		return null;
	}

	/**
	 * qm[h̐ԂB
	 *
	 * @return qm[h
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount()
	{
		return 0;
	}

	/**
	 * w肳ꂽm[h̃CfNXlԂB
	 *
	 * @param node m[h
	 * @return CfNX
	 * @see javax.swing.tree.TreeNode#getIndex(javax.swing.tree.TreeNode)
	 */
	public int getIndex(TreeNode node)
	{
		return 0;
	}
	
	/**
	 * em[hԂB
	 *
	 * @return em[h
	 * @see javax.swing.tree.TreeNode#getParent()
	 */
	public TreeNode getParent()
	{
		return parentNode;
	}

	/**
	 * [m[hǂԂB
	 *
	 * @return [m[hȂtrue
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf()
	{
		return true;
	}
	
	/**
	 * m[hԂB
	 *
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return process.getName() + "(" + process.getID() + ")";
	}
	
	/**
	 * m[h̏XVB
	 *
	 * @param filter
	 * @throws Exception
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#reload(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void reload(Filter filter) throws Exception
	{
	}
	
	/**
	 * m[h̃vpeBԂB
	 *
	 * @param rm \[X}l[W
	 * @return vpeB
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#getProperties()
	 */
	public Properties getProperties(ResourceManager rm)
	{
		Properties prop = new Properties();

		ProcessState state = ProcessState.getState(process.getProcessState());
		prop.put(rm.getResource("ProcessNode.key.0"), process.getID());
		prop.put(rm.getResource("ProcessNode.key.1"), "" + process.getName());
		prop.put(rm.getResource("ProcessNode.key.2"), "" + process.getPackageID());
		prop.put(rm.getResource("ProcessNode.key.3"), "" + process.getProcDefinitionID());
		prop.put(rm.getResource("ProcessNode.key.4"), "" + process.getDurationLimit());
		prop.put(rm.getResource("ProcessNode.key.5"), "" + process.getStartDate());
		prop.put(rm.getResource("ProcessNode.key.6"), "" + process.getStarterID());
		prop.put(rm.getResource("ProcessNode.key.7"), "" + process.getUpdateDate());
		prop.put(rm.getResource("ProcessNode.key.8"), state.toString());
		prop.put(rm.getResource("ProcessNode.key.9"), "" + state.toInt());

		return prop;
	}
	
	/**
	 * GWr[t[ԂB
	 *
	 * @return GWr[t[
	 */
	EngineViewFrame getFrame()
	{
		return parentNode.getFrame();
	}
	
	/**
	 * ێĂvZXԂB
	 *
	 * @return vZX
	 */
	Process getProcess()
	{
		return process;
	}

	/**
	 * vZXݒ肷B
	 * 
	 * @param process vZX
	 */
	public void setProcess(Process process)
	{
		this.process = process;
	}
}
