/* $Id: EngineInfo.java,v 1.7 2005/08/26 04:46:11 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;

/**
 * GWڑ\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class EngineInfo
{
	/** OSˑ̃t@C؂ */
	static public final String UNSET = "(unset)";

	/** GW */
	private String name;
	/** URL */
	private String url;
	/** XR[v */
	private String scope;
	/** [U */
	private String user;
	/** pX[h */
	private String password;
	/** Ǘ҃L[ */
	private String adminKey;
	/** ReLXg */
	private Context context;
	/** [Nt[T[rXANZbT */
	private WorkflowServiceAccessor wsa;

	/**
	 * ̃GW𐶐B
	 */
	public EngineInfo()
	{
	}

	/**
	 * Ɏw肳ꂽ񂩂GW𐶐B
	 *
	 * @param name GW
	 * @param url URL
	 * @param scope XR[v
	 * @param user [U
	 * @param password pX[h
	 * @param adminKey Ǘ҃L[
	 */
	public EngineInfo(String name, String url, String scope, String user,
			String password, String adminKey)
	{
		this.name     = name;
		this.url      = url;
		this.scope    = scope;
		this.user     = user;
		this.password = password;
		this.adminKey = adminKey;
	}

	/**
	 * [Uݒt@C̓eGW𐶐B
	 *
	 * @param doc GWXMLhLg
	 */
	EngineInfo(EngineInformationDocument.EngineInformation info)
	{
		this.name     = info.getName();
		this.url      = info.getUrl();
		this.scope    = info.getScope();
		this.user     = info.getUser();
		this.password = info.getPassword();
		this.adminKey = info.getAdminKey();
	}
	
	/**
	 * nameԂB
	 *
	 * @return name̒l
	 */
	public String getName()
	{
		if (name == null || name.trim().equals("")) return UNSET;
		return name;
	}

	/**
	 * urlԂB
	 *
	 * @return url̒l
	 */
	public String getURL()
	{
		if (url == null || url.trim().equals("")) return UNSET;
		return url;
	}

	/**
	 * scopeԂB
	 *
	 * @return scope̒l
	 */
	public String getScope()
	{
		if (scope == null || scope.trim().equals("")) return "";
		return scope;
	}

	/**
	 * userԂB
	 *
	 * @return user̒l
	 */
	public String getUser()
	{
		if (user == null || user.trim().equals("")) return UNSET;
		return user;
	}

	/**
	 * passwordԂB
	 *
	 * @return password̒l
	 */
	public String getPassword()
	{
		if (password == null || password.trim().equals("")) return "";
		return password;
	}

	/**
	 * adminKeyԂB
	 *
	 * @return adminKey̒l
	 */
	public String getAdminKey()
	{
		if (adminKey == null || adminKey.trim().equals("")) return "";
		return adminKey;
	}

	/**
	 * nameݒ肷B
	 * 
	 * @param name nameւ̐ݒl
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * urlݒ肷B
	 * 
	 * @param url urlւ̐ݒl
	 */
	public void setURL(String url)
	{
		init();
		this.url = url;
	}

	/**
	 * scopeݒ肷B
	 * 
	 * @param scope scopeւ̐ݒl
	 */
	public void setScope(String scope)
	{
		init();
		this.scope = scope;
	}

	/**
	 * userݒ肷B
	 * 
	 * @param user userւ̐ݒl
	 */
	public void setUser(String user)
	{
		init();
		this.user = user;
	}

	/**
	 * passwordݒ肷B
	 * 
	 * @param password passwordւ̐ݒl
	 */
	public void setPassword(String password)
	{
		init();
		this.password = password;
	}
	
	/**
	 * adminKeyݒ肷B
	 * 
	 * @param adminKey adminKeyւ̐ݒl
	 */
	public void setAdminKey(String adminKey)
	{
		init();
		this.adminKey = adminKey;
	}
	
	/**
	 * l[~OReLXgԂB
	 *
	 * @return ReLXg
	 * @throws NamingException l[~OO
	 */
	public Context getContext() throws NamingException
	{
		if (context == null)  {
			Properties prop = new Properties();
			prop.setProperty("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
			prop.setProperty("java.naming.provider.url", url);
			context = new InitialContext(prop);
		}
		return context;
	}
	
	/**
	 * GWɑΉ[Nt[T[rXANZbTԂB
	 *
	 * @return [Nt[T[rXANZbT
	 */
	public WorkflowServiceAccessor getWorkflowServiceAccessor()
	{
		if (wsa == null) {
			ConnectionInfo cinfo = getConnectionInfo();
			Context ctxt = null;
			try {
				ctxt = getContext();
			} catch (NamingException ex) {}
			wsa = new WorkflowServiceAccessor(cinfo, ctxt);
		}
		return wsa;
	}

	/**
	 * ݂̒lAڑ𐶐ĕԂB
	 *
	 * @return ڑ
	 */
	private ConnectionInfo getConnectionInfo()
	{
		ConnectionInfo cinfo = new ConnectionInfo(url, scope, user, password);
		return cinfo;
	}
	
	/**
	 * ԂB
	 */
	private void init()
	{
		try {
			if (context != null) context.close();
		} catch (NamingException ex) {}
		context = null;
		wsa = null;
	}
}
