/* $Id: PreferenceComponent.java,v 1.3 2005/08/26 04:46:12 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;

/**
 * [UݒpʃRec
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class PreferenceComponent
extends DialogComponent
{
	/** e[u̗ */
	static private String[] columnNames;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** GWe[u */
	private JTable engineInfoTable;
	/** GWǉ{^ */
	private JButton addInfoButton;
	/** GWҏW{^ */
	private JButton editInfoButton;
	/** GW폜{^ */
	private JButton delInfoButton;
	
	/** GWҏW */
	private EngineInfoComponent engineInfoComponent;

	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		columnNames = new String[4];
		columnNames[0] = rm.getResource("PreferenceComponent.columnName.0");
		columnNames[1] = rm.getResource("PreferenceComponent.columnName.1");
		columnNames[2] = rm.getResource("PreferenceComponent.columnName.2");
		columnNames[3] = rm.getResource("PreferenceComponent.columnName.3");
	}

	/**
	 * [Uݒpʂ𐶐B
	 */
	public PreferenceComponent()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		engineInfoComponent = new EngineInfoComponent();

		JPanel panel = createEngineInfoPanel(rm);
		addTab(rm.getResource("PreferenceComponent.tab.0"), panel);

		validate();
	}
	
	/**
	 * GWꗗ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createEngineInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(500, 365);
		panel.setSize(size);
		panel.setPreferredSize(size);

		engineInfoTable = new JTable(new EngineInfoTableModel());
		engineInfoTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(engineInfoTable);
		sp.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));

		addInfoButton = new JButton(rm.getResource("JButton.label.add"));
		addInfoButton.addActionListener(new AddInfoAction());
		editInfoButton = new JButton(rm.getResource("JButton.label.edit"));
		editInfoButton.addActionListener(new EditInfoAction());
		delInfoButton = new JButton(rm.getResource("JButton.label.delete"));
		delInfoButton.addActionListener(new DeleteInfoAction());

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));
		buttonPane.add(addInfoButton);
		buttonPane.add(editInfoButton);
		buttonPane.add(delInfoButton);
		
		panel.add(sp, BorderLayout.CENTER);
		panel.add(buttonPane, BorderLayout.SOUTH);

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#init()
	 */
	public void init()
	{
	}

	/**
	 * 
	 *
	 * @return
	 * @see jp.co.argo21.nautica.tool.wfadm.common.DialogComponent#commit()
	 */
	public boolean commit()
	{
		return true;
	}

	/**
	 * GWǉB
	 */	
	class AddInfoAction extends AbstractAction
	{
		/**
		 * GWǉB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			engineInfoComponent.setEngineInfo(null);
			if (PreferenceDialog.showDialog(PreferenceComponent.this, engineInfoComponent)) {
				EngineInfo info = engineInfoComponent.getEngineInfo();
				if (info != null) {
					PreferenceManager pm = PreferenceManager.getInstance();
					pm.addEngineInfo(info);
				}
			}
			engineInfoTable.updateUI();
		}
	}
	
	/**
	 * GWҏW
	 */	
	class EditInfoAction extends AbstractAction
	{
		/**
		 * GWҏWB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			int selected = engineInfoTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("W9001"));
				return;
			}
			PreferenceManager pm = PreferenceManager.getInstance();
			EngineInfo info = pm.getEngineInfo(selected);
			engineInfoComponent.setEngineInfo(info);
			if (PreferenceDialog.showDialog(PreferenceComponent.this, engineInfoComponent)) {
				EngineInfo updateinfo = engineInfoComponent.getEngineInfo();
				if (updateinfo != null) {
					pm.updateEngineInfo(selected, updateinfo);
				}
			}
			engineInfoTable.updateUI();
		}
	}
	
	/**
	 * GW폜B
	 */	
	class DeleteInfoAction extends AbstractAction
	{
		/**
		 * GW폜B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			int selected = engineInfoTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("W9001"));
				return;
			}
			PreferenceManager pm = PreferenceManager.getInstance();
			pm.removeEngineInfo(selected);

			engineInfoTable.clearSelection();
			engineInfoTable.updateUI();
		}
	}
	
	/**
	 * GWe[u䃂f
	 */
	class EngineInfoTableModel extends AbstractTableModel
	{
		/**
		 * GWe[u䃂f𐶐B
		 */
		EngineInfoTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return columnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			PreferenceManager pm = PreferenceManager.getInstance();
			return pm.getEngineInfoCount();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			PreferenceManager pm = PreferenceManager.getInstance();
			EngineInfo info = pm.getEngineInfo(row);
			if (info == null) return "";
			
			if (col == 0) {
				return info.getName();
			} else if (col == 1) {
				return info.getURL();
			} else if (col == 2) {
				return info.getScope();
			} else if (col == 3) {
				return info.getUser();
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
