/* $Id: PreferenceDialog.java,v 1.3 2005/08/26 04:46:13 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;

/**
 * [Uݒ\p̃_CAO񋟂B
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class PreferenceDialog extends JDialog
{
	/** \DialogComponent */
	private DialogComponent dialogComponent;
	/** ؂ʂǂ̃tO */
	private boolean commited;

	/**
	 * _CAO\B
	 * 
	 * @param c	eR|[lg
	 * @param elem	vf
	 * @return	XVꂽvf
	 */
	public static boolean showDialog(Component c, DialogComponent dc)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		PreferenceDialog dialog = new PreferenceDialog(frame, dc);
		dialog.setVisible(true);
		boolean committed = dialog.commited;
		dialog.dispose();

		return committed;
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame	et[
	 * @param elem	vf
	 */
	private PreferenceDialog(Frame frame, DialogComponent dc)
	{
		super(frame, true);
		
		dialogComponent = dc;
		createDialog();
		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO쐬B
	 */
	private void createDialog()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		setTitle(rm.getResource("PreferenceDialog.title"));
		
		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView((JComponent)dialogComponent);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton setButton = new JButton(rm.getResource("JButton.label.set"));
		setButton.setActionCommand("OK_OPTION");
		setButton.addActionListener(listener);
		getRootPane().setDefaultButton(setButton);
		buttonPane.add(setButton);

		JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
		cancelButton.addActionListener(listener);
		buttonPane.add(cancelButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();
	}

	/**
	 * _CAOƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * ؂sĂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("OK_OPTION".equals(e.getActionCommand())) {
				if (dialogComponent.commit() == false) return;
				commited = true;
			}
			setVisible(false);
		}
	}
}
