/* $Id: PreferenceManager.java,v 1.8 2005/08/26 04:46:11 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.pref;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/**
 * [UݒǗNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class PreferenceManager
{
	/** OSˑ̃t@C؂ */
	static public final String SEP = System.getProperty("file.separator");
	/** [Uݒt@C */
	static private final String PREF_FILE = SEP + "preferences.xml";
	/** PreferenceManager̃VOg */
	static private PreferenceManager singleton;

	/** AvP[Vf[^pX */
	private String appDataPath;
	/** [Uݒt@CpX */
	private String prefPath;
	/** GW */
	private ArrayList engineInfos = new ArrayList();
	
	/**
	 * PreferenceManager̐ƏsB
	 *
	 * @throws Exception Cӂ̗O
	 */
	static public void create() throws Exception
	{
		singleton = new PreferenceManager();
		singleton.init();
	}

	/**
	 * PreferenceManager̃CX^XԂB
	 *
	 * @return PreferenceManager
	 */
	static public PreferenceManager getInstance()
	{
		return singleton;
	}
	
	/**
	 * PreferenceManager𐶐B
	 */
	private PreferenceManager()
	{
	}
	
	/**
	 * PreferenceManagerB
	 *
	 * @throws Exception Cӂ̗O
	 */
	private void init() throws Exception
	{
		initPath();
		loadPreferences();
	}
	
	/**
	 * AvP[Vf[^i[p̃fBNg̃pXԂB
	 * ꏊ́A[Ũz[fBNgz̈ȉ̏ꏊƂB
	 * <pre>
	 * 
	 * Windows
	 * ${HOME}/Application Data/Nautica/WorkflowAdmin
	 * 
	 * Linux
	 * ${HOME}/.nautica/WorkflowAdmin
	 * 
	 * </pre>
	 * ̏ꏊȂꍇ́AJgԂB
	 * @return pX
	 */
	public String getApplicationDataPath()
	{
		return appDataPath;
	}
	
	/**
	 * ݂̃GWꗗԂB
	 *
	 * @return GWꗗ
	 */
	public List getAllEngineInfo()
	{
		return engineInfos;
	}

	/**
	 * GW񖼂ɑΉGWԂB
	 * ȂnullԂB
	 *
	 * @param engineName GW
	 * @return GW
	 */
	public EngineInfo getEngineInfo(String engineName)
	{
		if (engineName == null || engineName.trim().equals("")) return null;

		Iterator it = engineInfos.iterator();
		while (it.hasNext()) {
			EngineInfo info = (EngineInfo)it.next();
			String name = info.getName();
			if (name.equals(engineName)) {
				return info;
			}
		}
		return null;
	}

	/**
	 * CfNXɑΉGWԂB
	 * ȂnullԂB
	 *
	 * @param index CfNX
	 * @return GW
	 */
	public EngineInfo getEngineInfo(int index)
	{
		if (index < 0 || index >= engineInfos.size()) return null;

		EngineInfo info = (EngineInfo)engineInfos.get(index);
		return info;
	}
	
	/**
	 * GWǉB
	 * ǉɐꍇ́AtrueԂB
	 *
	 * @param info GW
	 * @return s
	 */
	public boolean addEngineInfo(EngineInfo info)
	{
		if (info == null) return false;
		String name = info.getName();
		EngineInfo ei = getEngineInfo(name);
		if (ei != null) return false;

		engineInfos.add(info);
		return true;
	}
	
	/**
	 * GWXVB
	 * XVɐꍇ́AtrueԂB
	 *
	 * @param info GW
	 * @return s
	 */
	public boolean  updateEngineInfo(EngineInfo info)
	{
		if (info == null) return false;
		String name = info.getName();
		EngineInfo ei = getEngineInfo(name);
		if (ei == null) return false;

		int ix = engineInfos.indexOf(ei);
		engineInfos.set(ix, info);
		return true;
	}
	
	/**
	 * CfNXɑΉGWXVB
	 * XVɐꍇ́AtrueԂB
	 *
	 * @param index CfNX
	 * @param info GW
	 * @return s
	 */
	public boolean  updateEngineInfo(int index, EngineInfo info)
	{
		if (index < 0 || index >= engineInfos.size()) return false;
		if (info == null) return false;
		String name = info.getName();
		EngineInfo ei1 = getEngineInfo(name);
		EngineInfo ei2 = getEngineInfo(index);
		if (ei1 != null) {
			if (ei1 != ei2) return false;
		}

		engineInfos.set(index, info);
		return true;
	}
	
	/**
	 * GW폜B
	 * 폜ɐꍇ́AtrueԂB
	 *
	 * @param engineName GW
	 * @return s
	 */
	public boolean removeEngineInfo(String engineName)
	{
		EngineInfo ei = getEngineInfo(engineName);
		if (ei == null) return false;

		int ix = engineInfos.indexOf(ei);
		engineInfos.remove(ix);
		return true;
	}
	
	/**
	 * CfNXɑΉGW폜B
	 * 폜ɐꍇ́AtrueԂB
	 *
	 * @param index CfNX
	 * @return s
	 */
	public boolean removeEngineInfo(int index)
	{
		if (index < 0 || index >= engineInfos.size()) return false;
		engineInfos.remove(index);
		return true;
	}
	
	/**
	 * ǗĂGW̌ԂB
	 *
	 * @return GW̌
	 */
	public int getEngineInfoCount()
	{
		return engineInfos.size();
	}
	
	/**
	 * ݂̃[Uݒt@C烍[hB
	 */
	public void load()
	throws IOException, XmlException
	{
		loadPreferences();
	}
	
	/**
	 * ݂̃[Uݒt@CɕۑB
	 */
	public void save()
	throws IOException, XmlException
	{
		savePreferences();
	}
	
	/**
	 * [Uݒ胍[hB
	 *
	 * @throws IOException IOO
	 * @throws XmlException XMLO
	 */
	private void loadPreferences()
	throws IOException, XmlException
	{
		engineInfos.clear();

		File f = new File(prefPath);
		if (f.exists()) {
			InputStream in = new FileInputStream(f);
			XmlOptions opts = new XmlOptions();
			opts.setCharacterEncoding("utf-8");
			AdminPreferencesDocument doc = AdminPreferencesDocument.Factory.parse(in, opts);
			in.close();
			
			AdminPreferencesDocument.AdminPreferences prefs =
				doc.getAdminPreferences();
			if (prefs != null) {
				EngineInformationsDocument.EngineInformations einfos = prefs.getEngineInformations();
				loadEngineInformations(einfos);
			}
		}
	}
	
	/**
	 * XMLIuWFNgGW[hB
	 *
	 * @param einfos XMLIuWFNg
	 */
	private void loadEngineInformations(EngineInformationsDocument.EngineInformations einfos)
	{
		if (einfos == null) return;
		
		EngineInformationDocument.EngineInformation[] einfo =
			einfos.getEngineInformationArray();
		if (einfo == null) return;
		
		for (int i = 0; i < einfo.length; i++) {
			loadEngineInformation(einfo[i]);
		}
	}
	
	/**
	 * XMLIuWFNgЂƂ̃GW[hB
	 *
	 * @param einfo XMLIuWFNg
	 */
	private void loadEngineInformation(EngineInformationDocument.EngineInformation einfo)
	{
		if (einfo == null) return;
		
		String name = einfo.getName();
		EngineInfo info = new EngineInfo(einfo);
		engineInfos.add(info);
	}
	
	
	/**
	 * [UݒۑB
	 *
	 * @throws IOException IOO
	 * @throws XmlException XMLO
	 */
	private void savePreferences()
	throws IOException, XmlException
	{
		AdminPreferencesDocument doc = AdminPreferencesDocument.Factory.newInstance();
		AdminPreferencesDocument.AdminPreferences prefs =
			doc.getAdminPreferences();
		if (prefs == null) {
			prefs = doc.addNewAdminPreferences();
		}
		
		EngineInformationsDocument.EngineInformations einfos = prefs.getEngineInformations();
		if (einfos == null) {
			einfos = prefs.addNewEngineInformations();
			saveEngineInformations(einfos);
		}
		
		OutputStream out = new FileOutputStream(prefPath);
		XmlOptions opts = new XmlOptions();
		opts.setSavePrettyPrint();
		opts.setSavePrettyPrintIndent(2);
		opts.setCharacterEncoding("utf-8");
		doc.save(out, opts);
		out.close();
	}
	
	/**
	 * GWXMLɊi[B
	 *
	 * @param einfos XMLIuWFNg
	 */
	private void saveEngineInformations(EngineInformationsDocument.EngineInformations einfos)
	{
		Iterator it = engineInfos.iterator();
		
		while (it.hasNext()) {
			EngineInfo info = (EngineInfo)it.next();
			if (info != null) {
				EngineInformationDocument.EngineInformation einfo =
					einfos.addNewEngineInformation();
				einfo.setName(info.getName());
				einfo.setUrl(info.getURL());
				einfo.setScope(info.getScope());
				einfo.setUser(info.getUser());
				einfo.setPassword(info.getPassword());
				einfo.setAdminKey(info.getAdminKey());
			}
		}
	}
	
	/**
	 * AvP[Vf[^i[p̃fBNg̃pXB
	 * ꏊ́A[Ũz[fBNgz̈ȉ̏ꏊƂB
	 * <pre>
	 * 
	 * [Windows]
	 * $${HOME}/Application Data/Nautica/WorkflowAdmin
	 * 
	 * [Linux]
	 * $${HOME}/.nautica/WorkflowAdmin
	 * 
	 * </pre>
	 * ̏ꏊȂꍇ́AJgpXƂB
	 */
	private void initPath()
	{
		String path = System.getProperty("user.home", ".");
		String osname = System.getProperty("os.name");

		//OSƂɃpX𐶐
		if (osname.indexOf("Windows") >= 0) {
			// Windows
			path += SEP + "Application Data" + SEP + "Nautica" + SEP + "WorkflowAdmin";
		} else {
			// ̑̊(Linux, Solaris, Mac OS X...these are un*x os.)
			path += SEP + ".nautica" + SEP + "WorkflowAdmin";
		}
		
		//pX̑݃`FbNƍ쐬
		File dir = new File(path);
		if (dir.exists() == false) {
			boolean created = dir.mkdirs();
			if (created == false) {
				//łȂꍇ́AJgԂB
				path = ".";
			}
		}
		
		appDataPath = path;
		prefPath = path + PREF_FILE;
	}
}
