/* $Id: DefinitionRepositorySoapBindingImpl.java,v 1.12 2005/08/26 04:51:56 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.ProcDef;
import jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

import org.apache.log4j.Logger;

/**
 * Web T[rXƂČJC^tF[X SOAP oCfBONXłB
 * XPDLt@CƖ̂̃}bsOǗĂAvɉāAXPDLIuWFNgĕԂB
 * 
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class DefinitionRepositorySoapBindingImpl {
	
	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			DefinitionRepositorySoapBindingImpl.class);
	
	/**
	 * RXgN^
	 *
	 */
	public DefinitionRepositorySoapBindingImpl() {
		// ȂB
	}
	
	
	/**
	 * w肳ꂽ`̓o^sAGWɔFB
	 *
	 * @param session ZbVID
	 * @param name [Nt[`
	 * @param path [Nt[`̑΃pX
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException vZXCX^XIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void registerDefinition(String session, String name, String path)
	throws InvalidSessionException, WorkflowException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", WorkflowDefinitionName=" + name 
			+ ", WorkflowDefinitionPath=" + path +")";
		log.info(I4001);
		
		try {
			DefinitionRepositoryRemote drr 
				= WorkflowRemoteServiceAccessor.getDefinitionRepositoryRemote(session);
			drr.registerDefinition(session, name, path);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
		log.info(I4002);
	}

	/**
	 * Ƀ}b`vZX`ꗗԂB
	 *
	 * @param session ZbVID
	 * @param filters ptB^[
	 * @return ꂽvZX`Tv̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public ProcDef[] getProcessDefinitions(
			String session, Filter[] filters)
	throws InvalidSessionException, InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
		
		ProcDef[] pds = null;
		try {
			DefinitionRepositoryRemote drr 
				= WorkflowRemoteServiceAccessor.getDefinitionRepositoryRemote(session);
			pds = SoapMessageConverter.convertToSoapMessage(
					drr.getProcessDefinitions(
							session, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
        
       String I4002 = StringManager.get("I4002")
	   		+ "(ProcessDefinitions=" + pds + ")";
       log.info(I4002);
       return pds;
    }

	/**
	 * vZX`IDœ肳ꂽ`݂̌̏ԂJډ\
	 * vZX`ԈꗗԂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @return vZX`Ԃ̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public ProcessDefinitionState[] getProcessDefinitionStates(
			String session,String pdid)
	throws InvalidSessionException, InvalidProcessDefinitionException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid + ")";
		log.info(I4001);
		
		ProcessDefinitionState[] pdss = null;
		try {
			DefinitionRepositoryRemote drr 
				= WorkflowRemoteServiceAccessor.getDefinitionRepositoryRemote(session);
			pdss = SoapMessageConverter.convertToSoapMessage(
				drr.getProcessDefinitionStates(session, pdid));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002")
			+ "(ProcessDefinitionStates=" + pdss + ")";
	   	log.info(I4002);
		return pdss;
	}

	/**
	 * vZX`ԂύXB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param state vZX`
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeProcessDefinitionState(String session,
			String pdid, ProcessDefinitionState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidStateException, TransitionNotAllowedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", ProcessDefinitionState=" + state + ")";
		log.info(I4001);
		
		try {
			DefinitionRepositoryRemote drr 
				= WorkflowRemoteServiceAccessor.getDefinitionRepositoryRemote(session);
			drr.changeProcessDefinitionState(
					session, 
					pdid, 
					state.toWfmcProcessDefinitionState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
}
