/* $Id: SoapMessageConverter.java,v 1.8 2005/08/26 04:51:55 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.soap;

import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.filter.AttributeFilter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.soap.message.Activity;
import jp.co.argo21.nautica.workflow.soap.message.ActivityState;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.ProcDef;
import jp.co.argo21.nautica.workflow.soap.message.Process;
import jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.soap.message.ProcessState;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;
import jp.co.argo21.nautica.workflow.soap.message.WorkItemState;

/**
 * SOAP bZ[WIuWFNgGWŎgpIuWFNg
 * ɕϊ郆[eBeBNXłB 
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
class SoapMessageConverter {

	private static int NAME_FILTER_TYPE  		= 5001;
	private static int STATE_FILTER_TYPE 		= 5002;
	private static int ATTRIBUTE_FILTER_TYPE 	= 5003;
	private static int GROUP_FILTER_TYPE 		= 5004;
	
	private static String PROC_DEF_STATE_TYPE	 = "ProcessDefinitionState";
	private static String PROCESS_STATE_TYPE	 = "ProcessState";
	private static String ACTIVITY_STATE_TYPE	 = "ActivityState";
	private static String WORK_ITEM_STATE_TYPE = "WorkItemState";
	
	
	/**
	 * jp.co.argo21.nautica.workflow.soap.message.Filter IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.wfmc.Filter IuWFNg (GroupFilter) 
	 * ϊB
	 *  filters  null ͋̔z񂪎w肳ꂽꍇAnull ԂB
	 * [Nt[GW̌JAPIň Filter IuWFNg null ̏ꍇ́A
	 * tB^OɑSsȂdlłB
	 *
	 * @param filters jp.co.argo21.nautica.workflow.soap.message.Filter IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.wfmc.Filter IuWFNg
	 */
	static GroupFilter convertToGroupFilter(Filter[] filters) {
		if (filters == null || filters.length < 1) {
			return null;
		}
		
		List groupFilters = new ArrayList();
		for (int i=0; i<filters.length; i++) {
			Filter filter = filters[i];
			int filterType = filter.getType();

			if (filterType == ATTRIBUTE_FILTER_TYPE) {
                jp.co.argo21.nautica.workflow.wfmc.Filter af = 
					new AttributeFilter(
							filter.getFilterName(), 
							filter.getComparison(), 
							filter.getFilterString());
				groupFilters.add(af);
			
			} else if (filterType == NAME_FILTER_TYPE) {
                jp.co.argo21.nautica.workflow.wfmc.Filter nf = 
					new NameFilter(
							filter.getFilterString(), 
							filter.getComparison());
				groupFilters.add(nf);
				
			} else if (filterType == STATE_FILTER_TYPE) {
				Filter[] stateFilters = new Filter[]{filter}; // convertToStateFilter gp邽
				jp.co.argo21.nautica.workflow.wfmc.Filter sf = convertToStateFilter(stateFilters);
				groupFilters.add(sf);
                
				
			} else if (filterType == GROUP_FILTER_TYPE) {
				throw new IllegalArgumentException(
					"Illegal Filter Type(FilterType=" + filterType + ")");
				
			} else {
				throw new IllegalArgumentException(
					"Illegal Filter Type(FilterType=" + filterType + ")");
			}
		}
		// XgzɕϊĕԂB
		return new GroupFilter(
				(jp.co.argo21.nautica.workflow.wfmc.Filter[])
				groupFilters.toArray(new jp.co.argo21.nautica.workflow.wfmc.Filter[0]));
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.soap.message.Filter IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.wfmc.StateFilter IuWFNg (StateGroupFilter) 
	 * ϊB
	 * ̔zɂ StateFilter  1 ݂̂Ȃ̂ŁA2ȏ Filter ꍇ́A
	 * sO𓊂B
	 *  filters  null ͋̔z񂪎w肳ꂽꍇAnull ԂB
	 * [Nt[GW̌JAPIň Filter IuWFNg null ̏ꍇ́A
	 * tB^OɑSsȂdlłB
	 *
	 * @param filters jp.co.argo21.nautica.workflow.soap.message.Filter IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.wfmc.Filter IuWFNg
	 */
	static StateFilter convertToStateFilter(Filter[] filters) {
		if (filters == null || filters.length < 1) {
			return null;
		}
		if (filters.length > 1) {
			throw new IllegalArgumentException(
					"Illegal Number of StateFilter" 
				   + "(Number of Filter=" + filters.length + ")");
		}
		
		StateFilter filter = null;
		String stateType = filters[0].getFilterName();
		if (stateType.equalsIgnoreCase(WORK_ITEM_STATE_TYPE)) {
			WorkItemState state = new WorkItemState(
					filters[0].getFilterString());
			filter = new StateFilter(state.toWfmcWorkItemState());
			
		} else if (stateType.equalsIgnoreCase(PROC_DEF_STATE_TYPE)) {
			ProcessDefinitionState state = new ProcessDefinitionState(
					filters[0].getFilterString());
			filter = new StateFilter(state.toWfmcProcessDefinitionState());
		
		} else if (stateType.equalsIgnoreCase(PROCESS_STATE_TYPE)) {
			ProcessState state = new ProcessState(
					filters[0].getFilterString());
			filter = new StateFilter(state.toWfmcProcessState());
			
		} else if (stateType.equalsIgnoreCase(ACTIVITY_STATE_TYPE)) {
			ActivityState state = new ActivityState(
					filters[0].getFilterString());
			filter = new StateFilter(state.toWfmcActivityState());
			
		} else {
			// ܂ԕݒ肵ꍇ
			throw new IllegalArgumentException(
					"Illegal StateFilter's State Type"
					+ "(StateType=" + stateType + ")");
		}
		return filter;
	}
	
	
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.Activity IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.Activity IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds wpd jp.co.argo21.nautica.workflow.wfmc.Activitys IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.Activity IuWFNg̔z
	 */
	static Activity[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.Activity[] was) {
		Activity[] as = new Activity[was.length];
		for (int i=0; i<was.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.Activity wa = was[i];
			as[i] = new Activity(wa);
		}
		return as;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.ProcessState IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.ProcessState IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState IuWFNg̔z
	 */
	static ActivityState[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.ActivityState[] wass) {
		ActivityState[] ass = new ActivityState[wass.length];
		for (int i=0; i<wass.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.ActivityState was = wass[i];
			ass[i] = new ActivityState(was);
		}
		return ass;
	}
	
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.ProcDef IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.ProcDef IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds wpd jp.co.argo21.nautica.workflow.wfmc.ProcDef IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.ProcDef IuWFNg̔z
	 */
	static ProcDef[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.ProcDef[] wpds) {
		ProcDef[] pds = new ProcDef[wpds.length];
		for (int i=0; i<wpds.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.ProcDef wpd = wpds[i];
			pds[i] = new ProcDef(wpd);
		}
		return pds;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState IuWFNg̔z
	 */
	static ProcessDefinitionState[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState[] wpdss) {
		ProcessDefinitionState[] pdss = new ProcessDefinitionState[wpdss.length];
		for (int i=0; i<wpdss.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState wpds = wpdss[i];
			pdss[i] = new ProcessDefinitionState(wpds);
		}
		return pdss;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.Process IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.Process IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds wpd jp.co.argo21.nautica.workflow.wfmc.Process IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.Process IuWFNg̔z
	 */
	static Process[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.Process[] wps) {
		Process[] ps = new Process[wps.length];
		for (int i=0; i<wps.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.Process wp = wps[i];
			ps[i] = new Process(wp);
		}
		return ps;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.ProcessState IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.ProcessState IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState IuWFNg̔z
	 */
	static ProcessState[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.ProcessState[] wpss) {
		ProcessState[] pss = new ProcessState[wpss.length];
		for (int i=0; i<wpss.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.ProcessState wps = wpss[i];
			pss[i] = new ProcessState(wps);
		}
		return pss;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.Attribute IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.Attribute IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState IuWFNg̔z
	 */
	static Attribute[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.Attribute[] wattrs) {
		Attribute[] attrs = new Attribute[wattrs.length];
		for (int i=0; i<wattrs.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.Attribute wattr = wattrs[i];
			attrs[i] = new Attribute(wattr);
		}
		return attrs;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.WorkItem IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.WorkItem IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.WorkItem IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.WorkItem IuWFNg̔z
	 */
	static WorkItem[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.WorkItem[] wwis) {
		WorkItem[] wis = new WorkItem[wwis.length];
		for (int i=0; i<wwis.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.WorkItem wwi = wwis[i];
			wis[i] = new WorkItem(wwi);
		}
		return wis;
	}
	
	/**
	 * jp.co.argo21.nautica.workflow.wfmc.WorkItemState IuWFNg̔z
	 * jp.co.argo21.nautica.workflow.soap.message.WorkItemState IuWFNg̔z
	 * ϊB
	 *
	 * @param wpds jp.co.argo21.nautica.workflow.wfmc.WorkItemDefinitionState IuWFNg̔z
	 * @return jp.co.argo21.nautica.workflow.soap.message.WorkItemDefinitionState IuWFNg̔z
	 */
	static WorkItemState[] convertToSoapMessage(
			jp.co.argo21.nautica.workflow.wfmc.WorkItemState[] wwiss) {
		WorkItemState[] wiss = new WorkItemState[wwiss.length];
		for (int i=0; i<wwiss.length; i++) {
			jp.co.argo21.nautica.workflow.wfmc.WorkItemState wwis = wwiss[i];
			wiss[i] = new WorkItemState(wwis);
		}
		return wiss;
	}
	
	
}
