/* $Id: WorkItemHandlerSoapBindingImpl.java,v 1.16 2005/08/26 04:51:58 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.Participant;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;
import jp.co.argo21.nautica.workflow.soap.message.WorkItemState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

import org.apache.log4j.Logger;

/**
 * Web T[rXƂČJC^tF[X SOAP oCfBONXłB
 * [Nt[ɑ΂NCANXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.16 $
 * @since   Nautica Workflow 0.9
 */
public class WorkItemHandlerSoapBindingImpl {
	
	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			WorkItemHandlerSoapBindingImpl.class);
	
	/**
	 * RXgN^B
	 * 
	 */
	public WorkItemHandlerSoapBindingImpl() {
		// ȂB
	}
	
	/**
	 * ƍڈꗗ̎擾sB
	 *
	 * @param session ZbVID
	 * @param filters ptB^[
	 * @return ƍڈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public WorkItem[] getWorkItems(String session, Filter[] filters)
	throws InvalidSessionException, InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001") 
			+ "(SessionID=" + session 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		WorkItem[] wis = null;
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wis = SoapMessageConverter.convertToSoapMessage(
					wih.getWorkItems(
							session, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(WorkItems=" + wis + ")";
	   	log.info(I4002);
	   	
		return wis;	
	}

	/**
	 * ƍڂ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @return ƍ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public WorkItem getWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid + ")";
		log.info(I4001);
	
		WorkItem wi = null;
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wi = new WorkItem(wih.getWorkItem(session, wid));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002")
			+ "(WorkItem=" + wi + ")";
	   	log.info(I4002);
		return wi;
	}

	/**
	 * ƍڂ̊sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void completeWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid + ")";
		log.info(I4001);
	
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wih.completeWorkItem(session, wid);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * ݂̍ƍڂJډ\ȏԂ̈ꗗԂB
	 * ԂȂꍇ́A̔zԂB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filters ptB^[
	 * @return ƍڏԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public WorkItemState[] getWorkItemStates(String session,
			String wid, Filter[] filters)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		WorkItemState[] wiss = null;
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wiss = SoapMessageConverter.convertToSoapMessage(
					wih.getWorkItemStates(
							session, 
							wid, 
							SoapMessageConverter.convertToStateFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(WorkItemStates=" + wiss + ")";
	   	log.info(I4002);
		return wiss;
	}
	
	/**
	 * ƍڏԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param state ƍڏ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeWorkItemState(String session,
			String wid, WorkItemState state)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidStateException, TransitionNotAllowedException, 
		ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid 
			+ ", WorkItemState=" + state + ")";
		log.info(I4001);
	
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wih.changeWorkItemState(session, wid, state.toWfmcWorkItemState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
	
	/**
	 * ƍڂ̍Ċ蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param sourceUser 蓖đÕ[U
	 * @param targetUser 蓖Č̃[U
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidTargetUserException 蓖Đ惆[ULłȂꍇ
	 * @throws InvalidSourceUserException 蓖đO[ULłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void reassignWorkItem(String session,
			Participant sourceUser, Participant targetUser, String wid)
	throws InvalidSessionException, InvalidWorkItemException,
	InvalidSourceUserException, InvalidTargetUserException, 
	ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", SourceUser=" + sourceUser 
			+ ", TargetUser=" + targetUser  
			+ ", WorkItemID=" + wid + ")";
		log.info(I4001);
	
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wih.reassignWorkItem(
			        session, 
			        sourceUser.toWfmcParticipant(), 
			        targetUser.toWfmcParticipant(), 
			        wid);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
	
	/**
	 * ƍڑꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filters ptB^[
	 * @return ƍڑꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute[] getWorkItemAttributes(String session,
			String wid, Filter[] filters)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
		
		Attribute[] attrs = null;
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			attrs = SoapMessageConverter.convertToSoapMessage(
					wih.getWorkItemAttributes(
							session, 
							wid, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(̔z=" + attrs + ")";
	   	log.info(I4002);
		return attrs;
	}
	
	/**
	 * ƍڑ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute getWorkItemAttributeValue(String session,
			String wid, String name)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid 
			+ ", =" + name + ")";
		log.info(I4001);
	
		Attribute attr = null;
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			attr = new Attribute(
					wih.getWorkItemAttributeValue(session, wid, name));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002")
			+ "(=" + attr + ")";
	   	log.info(I4002);
		return attr;
	}
	

	/**
	 * ƍڑ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void assignWorkItemAttribute(String session,
			String wid, Attribute attr)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException, AttributeAssignmentFailedException, 
		ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", WorkItemID=" + wid 
			+ ", =" + attr + ")";
		log.info(I4001);
	
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wih.assignWorkItemAttribute(session, wid, attr.toWfmcAttribute());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
}
