/* $Id: WorkflowAdminHandlerSoapBindingImpl.java,v 1.14 2005/08/26 04:51:57 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;
import jp.co.argo21.nautica.workflow.soap.message.ActivityState;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.ProcessState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

import org.apache.log4j.Logger;

/**
 * Web T[rXƂČJC^tF[X SOAP oCfBONXłB
 * [Nt[ɑ΂ǗNCAgłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowAdminHandlerSoapBindingImpl {
	
	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			WorkflowAdminHandlerSoapBindingImpl.class);
	
	/**
	 * RXgN^
	 *
	 */
	public WorkflowAdminHandlerSoapBindingImpl() {
		// ȂB
	}
	
	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filters ptB^[
	 * @param state VvZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeProcessesState(String session,
			String pdid, Filter[] filters, ProcessState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidFilterException, InvalidStateException,
	TransitionNotAllowedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", Filters=" + filters  
			+ ", ProcessInstanceState=" + state + ")";
		log.info(I4001);
		
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.changeProcessesState(
					session, 
					pdid, 
					SoapMessageConverter.convertToStateFilter(filters), 
					state.toWfmcProcessState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filters ptB^[
	 * @param state VANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeActivitiesState(String session, String pdid, String adid, 
			Filter[] filters, ActivityState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidActivityNameException, InvalidFilterException,
	InvalidStateException, TransitionNotAllowedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", ActivityDefinitionID=" + adid
			+ ", Filters" + filters  
			+ ", ActivityInstanceState=" + state + ")";
		log.info(I4001);
	
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.changeActivitiesState(
					session, 
					pdid, 
					adid, 
					SoapMessageConverter.convertToStateFilter(filters), 
					state.toWfmcActivityState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁A~sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filters ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void terminateProcesses(String session,
			String pdid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.terminateProcesses(
					session, 
					pdid, 
					SoapMessageConverter.convertToGroupFilter(filters));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁Å蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filters ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void assignProcessesAttribute(String session,
			String pdid, Filter[] filters, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidAttributeException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", Filters" + filters 
			+ ", Attribute=" + attr + ")";
		log.info(I4001);
	
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.assignProcessesAttribute(
					session, 
					pdid, 
					SoapMessageConverter.convertToGroupFilter(filters), 
					attr.toWfmcAttribute());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁A
	 * ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filters ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void assignActivitiesAttribute(String session,
			String pdid, String adid, Filter[] filters, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", ActivityDefinitionID=" + adid 
			+ ", Filters=" + filters  
			+ ", Attribute=" + attr + ")";
		log.info(I4001);
	
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.assignActivitiesAttribute(
					session, 
					pdid, 
					adid, 
					SoapMessageConverter.convertToGroupFilter(filters), 
					attr.toWfmcAttribute());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AfsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filters ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void abortProcesses(String session, String pdid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.abortProcesses(
					session, 
					pdid, 
					SoapMessageConverter.convertToGroupFilter(filters));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽvZXCX^X̒fsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void abortProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid + ")";
		log.info(I4001);

		try {
			WorkflowAdminHandlerRemote wah 
				= WorkflowRemoteServiceAccessor.getWorkflowAdminHandlerRemote(session);
			wah.abortProcess(session, pid);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
}
