/* $Id: WorkflowEngineHandlerSoapBindingImpl.java,v 1.15 2005/08/26 04:51:52 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote;
import jp.co.argo21.nautica.workflow.soap.message.Activity;
import jp.co.argo21.nautica.workflow.soap.message.ActivityState;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.Process;
import jp.co.argo21.nautica.workflow.soap.message.ProcessState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

import org.apache.log4j.Logger;

/**
 * Web T[rXƂČJC^tF[X SOAP oCfBONXłB
 * [Nt[GWɑ΂NCAgNXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowEngineHandlerSoapBindingImpl {
   
	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			WorkflowEngineHandlerSoapBindingImpl.class);
	
	/**
	 * RXgN^B
	 * 
	 */
	public WorkflowEngineHandlerSoapBindingImpl() {
		// ȂB
	}
	
	/**
	 * vZXCX^X̐sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param name vZXCX^X
	 * @return vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public String createProcess(String session, String pdid, String name)
	throws InvalidSessionException, InvalidProcessDefinitionException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessDefinitionID=" + pdid 
			+ ", ProcessInstanceName=" + name + ")";
		log.info(I4001);
	
		String pid = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			pid = weh.createProcess(session, pdid, name);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002")
			+ "(ProcessInstanceID=" + pid + ")";
	   	log.info(I4002);
		return pid;
	}

	/**
	 * vZXCX^X̊JnsB
	 * JnꍇɁAvZXCX^XIDXV悤
	 * \łB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return XVꂽvZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public String startProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid + ")";
		log.info(I4001);
	
		String startedPid = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			startedPid = weh.startProcess(session, pid);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002")
			+ "(ProcessInstanceID=" + startedPid + ")";
	   	log.info(I4002);
		return startedPid;
	}

	/**
	 * vZXCX^X̒~sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void terminateProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid + ")";
		log.info(I4001);
	
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			weh.terminateProcess(session, pid);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
	
		String I4002 = StringManager.get("I4002");
		log.info(I4002);
	}

	/**
	 * w肳ꂽvZXCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filters ptB^[
	 * @return vZXCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public ProcessState[] getProcessStates(String session, 
			String pid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		ProcessState[] pss = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			pss = SoapMessageConverter.convertToSoapMessage(
					weh.getProcessStates(
							session, 
							pid, 
							SoapMessageConverter.convertToStateFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(ProcessInstances=" + pss + ")";
	   	log.info(I4002);
		return pss;
	}


	/**
	 * vZXCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeProcessState(String session,
			String pid, ProcessState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidStateException, TransitionNotAllowedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ProcessInstanceState=" + state + ")";
		log.info(I4001);
	
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			weh.changeProcessState(
					session, 
					pid, 
					state.toWfmcProcessState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filters ptB^[
	 * @return ꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute[] getProcessAttributes(String session,
			String pid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		Attribute[] attrs = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			attrs = SoapMessageConverter.convertToSoapMessage(
					weh.getProcessAttributes(
							session, 
							pid, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(Attributes=" + attrs + ")";
	   	log.info(I4002);
		return attrs;
	}

	/**
	 * vZXCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute getProcessAttributeValue(String session,
			String pid, String name)
	throws InvalidSessionException, InvalidAttributeException, 
		ServiceAccessorException{
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", AttributeName=" + name + ")";
		log.info(I4001);
	
		Attribute attr = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			attr = new Attribute(
					weh.getProcessAttributeValue(session, pid, name));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(Attribute=" + attr + ")";
	   	log.info(I4002);
		return attr;
	}

	/**
	 * vZXCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void assignProcessAttribute(String session,
			String pid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, AttributeAssignmentFailedException, 
		ServiceAccessorException { 
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", Attribute=" + attr + ")";
		log.info(I4001);
	
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			weh.assignProcessAttribute(session, pid, attr.toWfmcAttribute());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * w肳ꂽANeBreBCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filters ptB^[
	 * @return ANeBreBCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public ActivityState[] getActivityStates(String session,
			String pid, String aid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException, 
		ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ActivityInstanceID=" + aid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		ActivityState[] ass = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			ass = SoapMessageConverter.convertToSoapMessage(
					weh.getActivityStates(
							session, 
							pid, 
							aid, 
							SoapMessageConverter.convertToStateFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(ActivityInstanceStates=" + ass + ")";
	   	log.info(I4002);
		return ass;
	}

	/**
	 * ANeBreBCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param state ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void changeActivityState(String session,
			String pid, String aid, ActivityState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidStateException,
		TransitionNotAllowedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ActivityInstanceID=" + aid 
			+ ", ActivityInstanceState=" + state + ")";
		log.info(I4001);
	
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			weh.changeActivityState(
					session, 
					pid, 
					aid, 
					state.toWfmcActivityState());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filters ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute[] getActivityAttributes(String session,
			String pid, String aid, Filter[] filters)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException, 
		ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ActivityInstanceID=" + aid 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		Attribute[] attrs = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			attrs = SoapMessageConverter.convertToSoapMessage(
					weh.getActivityAttributes(
							session, 
							pid, 
							aid, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002")
			+ "(ActivityInstanceAttributes=" + attrs + ")";
	   	log.info(I4002);
		return attrs;
	}
	/**
	 * ANeBreBCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Attribute getActivityAttributeValue(String session,
			String pid, String aid, String name)
	throws InvalidSessionException, InvalidAttributeException,  
		ServiceAccessorException{
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ActivityInstanceID=" + aid 
			+ ", AttributeName=" + name + ")";
		log.info(I4001);
	
		Attribute attr = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			attr = new Attribute(
					weh.getActivityAttributeValue(session, pid, aid, name));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002")
			+ "(Attribute=" + attr + ")";
	   	log.info(I4002);
		return attr;
	}

	/**
	 * ANeBreBCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void assignActivityAttribute(String session,
			String pid, String aid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidAttributeException,
		AttributeAssignmentFailedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid 
			+ ", ActivityInstanceID=" + aid 
			+ ", AttributeName=" + attr.getName() + ")";
		log.info(I4001);
	
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			weh.assignActivityAttribute(
					session, 
					pid, 
					aid, 
					attr.toWfmcAttribute());
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param filters ptB^[
	 * @return vZẌꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Process[] getProcesses(String session, Filter[] filters)
	throws InvalidSessionException, InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		Process[] ps = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			ps = SoapMessageConverter.convertToSoapMessage(
					weh.getProcesses(
							session, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(Processes=" + ps + ")";
	   	log.info(I4002);
		return ps;
	}

	/**
	 * vZXCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Process getProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
	ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", ProcessInstanceID=" + pid + ")";
		log.info(I4001);
	
		Process p = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			p = new Process(
					weh.getProcess(session, pid));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(ProcessInstance=" + p + ")";
		log.info(I4002);
		return p;
	}

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param filters ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Activity[] getActivities(String session, Filter[] filters)
	throws InvalidSessionException, InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		Activity[] as = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			as = SoapMessageConverter.convertToSoapMessage(
					weh.getActivities(
							session, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(Activities=" + as + ")";
		log.info(I4002);
		return as;
	}
	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter݂̂ƂB
	 * WfMCdlłpid͂ȂA͌ł낤ƔfA
	 * pidɒǉB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filters ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Activity[] getActivities(String session, String pid, Filter[] filters)
	throws InvalidSessionException, InvalidFilterException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", ProcessInstanceID=" + pid
			+ ", Filters=" + filters + ")";
		log.info(I4001);
	
		Activity[] as = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			as = SoapMessageConverter.convertToSoapMessage(
					weh.getActivities(
							session, 
							pid, 
							SoapMessageConverter.convertToGroupFilter(filters)));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(Activities=" + as + ")";
		log.info(I4002);
		return as;
	}

	/**
	 * ANeBreBCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public Activity getActivity(String session, String pid, String aid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session
			+ ", ProcessInstanceID=" + pid
			+ ", ActivityInstanceID=" + aid + ")";
		log.info(I4001);
	
		Activity a = null;
		try {
			WorkflowEngineHandlerRemote weh 
				= WorkflowRemoteServiceAccessor.getEngineHandlerRemote(session);
			a = new Activity(
					weh.getActivity(session, pid, aid));
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002") 
			+ "(ActivityInstance=" + a + ")";
		log.info(I4002);
		return a;
	}
}
