/* $Id: WorkflowRemoteServiceAccessor.java,v 1.5 2005/08/26 04:51:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessorManager;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * [Nt[̃[gIuWFNg擾邽߂̃NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowRemoteServiceAccessor {

	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			WorkflowRemoteServiceAccessor.class);
	
	/**
	 * ZbVIDɊY`|Wg
	 * ԂB
	 * 
	 * @param session ZbVID
	 * @return `|Wg
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	static DefinitionRepositoryRemote getDefinitionRepositoryRemote(String session) 
	throws InvalidSessionException, RemoteException {
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
		WorkflowServiceAccessor wsa 
			= wsm.getServiceAccessor(session);
		
		DefinitionRepositoryRemote drr = null;
		try {
			drr = wsa.getDefinitionRepository();
			
		} catch (InvalidSessionException ex) {
			String errMsg = StringManager.get("E4005") 
				+ "(SessionID" + session + ")";
			log.error(errMsg, ex);
			throw ex;
		}
		return drr;
	}
	
	/**
	 * ZbVIDɊY郏[Nt[ǗNCAg
	 * ԂB
	 * 
	 * @param session ZbVID
	 * @return [Nt[ǗNCAg
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	static WorkflowAdminHandlerRemote getWorkflowAdminHandlerRemote(String session) 
	throws InvalidSessionException, RemoteException {
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
		WorkflowServiceAccessor wsa 
			= wsm.getServiceAccessor(session);
		
		WorkflowAdminHandlerRemote wah = null;
		try {
			wah = wsa.getWorkflowAdminHandler();
			
		} catch (InvalidSessionException ex) {
			String errMsg = StringManager.get("E4005") 
				+ "(SessionID" + session + ")";
			log.error(errMsg, ex);
			throw ex;
		}
		return wah;
	}
	
	/**
	 * ZbVIDɊYGWnh[ԂB
	 * 
	 * @param session ZbVID
	 * @return GWnh[
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	static WorkflowEngineHandlerRemote getEngineHandlerRemote(String session) 
	throws InvalidSessionException, RemoteException {
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
		WorkflowServiceAccessor wsa 
			= wsm.getServiceAccessor(session);
		
		WorkflowEngineHandlerRemote weh = null;
		try {
			weh = wsa.getWorkflowEngineHandler();
			
		} catch (InvalidSessionException ex) {
			String errMsg = StringManager.get("E4005") 
				+ "(SessionID" + session + ")";
			log.error(errMsg, ex);
			throw ex;
		}
		return weh;
	}
	
	/**
	 * ZbVIDɊY郏[NACenh[ԂB
	 * 
	 * @param session ZbVID
	 * @return [NACenh[
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	static WorkItemHandlerRemote getWorkItemHandlerRemote(String session) 
	throws InvalidSessionException, RemoteException {
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
		WorkflowServiceAccessor wsa 
			= wsm.getServiceAccessor(session);
		
		WorkItemHandlerRemote wih = null;
		try {
			wih = wsa.getWorkItemHandler();
			
		} catch (InvalidSessionException ex) {
			String errMsg = StringManager.get("E4005") 
				+ "(SessionID" + session + ")";
			log.error(errMsg, ex);
			throw ex;
		}
		return wih;
	}
}
