/* $Id: WorkflowServiceConnectorSoapBindingImpl.java,v 1.10 2005/08/26 04:51:59 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessorManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

import org.apache.log4j.Logger;

/**
 * Web T[rXƂČJC^tF[X SOAP oCfBONXłB
 * [Nt[GWɑ΂鑍NCAgNXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowServiceConnectorSoapBindingImpl {
    
	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			WorkflowServiceConnectorSoapBindingImpl.class);
	
	/**
	 * RXgN^
	 *
	 */
	public WorkflowServiceConnectorSoapBindingImpl() {
		// B
	}
	
	/**
	 * [Nt[GWւ̐ڑF؂sA
	 * ZbVID擾B
	 *
	 * @param user [UID
	 * @param pass pX[h
	 * @return ZbVID
	 * @throws ConnectionFailedException ڑF؂Ɏsꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public String connect(String user, String pass)
	throws ConnectionFailedException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(UserID=" + user + ")";
		log.info(I4001);
	
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
		
		String session = null;
		try {
			session = wsm.open(this.createConnectionInfo(user, pass));
			String I4004 = StringManager.get("I4004") 
				+ "(UserID=" + user 
				+ ", SessionID=" + session + ")";
			log.info(I4004);
		
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
			
		String I4002 = StringManager.get("I4002") 
			+ "(SessionID=" + session + ")";
	   	log.info(I4002);
		return session;
	}

	/**
	 * [Nt[GWƂ̐ؒfsB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws ServiceAccessorException ʐMQɂ胏[Nt[GWƐڑłȂꍇ
	 */
	public void disconnect(String session)
	throws InvalidSessionException, ServiceAccessorException {
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session + ")";
		log.info(I4001);
	
		WorkflowServiceAccessorManager wsm 
			= WorkflowServiceAccessorManager.getInstance();
	
		try {
			wsm.close(session);
			String I4005 = StringManager.get("I4005") 
				+ "(SessionID=" + session + ")";
			log.info(I4005);
		
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg, ex);
			throw new ServiceAccessorException(errMsg);
		}
		
		String I4002 = StringManager.get("I4002");
	   	log.info(I4002);
	}
	
	/**
	 * ڑVK쐬AԂB
	 *
	 * @param user [UID
	 * @param pass pX[h
	 * @return ڑ
	 */
	private ConnectionInfo createConnectionInfo(String user, String pass) {
		return new ConnectionInfo(
				WorkflowAxisConfig.getInstance().getURL(), 
				WorkflowAxisConfig.getInstance().getScope(), 
				user, 
				pass);
	}
}
