/* $Id: Activity.java,v 1.6 2005/08/26 04:52:01 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

/**
 * ANeBreBCX^X SOAP bZ[W\킷NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class Activity  implements Serializable {
    private String activityDefinitionID;
    private String activityID;
    private int activityState;
    private String actorID;
    private String blockID;
    private String durationLimit;
    private String name;
    private String processID;
    private String startDate;
    private String starterID;
    private String updateDate;

    private static final DateFormat df = DateFormat.getDateInstance();
    
    /**
      * ANeBreB𐶐B
     * 
     */
    public Activity() {
    }

    /**
     * ANeBreB𐶐B
     * 
     * @param activityDefinitionID ANeBreB`ID
     * @param activityID ANeBreBID
     * @param activityState ANeBreB
     * @param actorID sID
     * @param blockID subNID
     * @param durationLimit s
     * @param name ANeBreBCX^X
     * @param processID vZXCX^XID
     * @param startDate Jn
     * @param starterID Jn
     * @param updateDate ŐVԍXV
     */
    public Activity(
           String activityDefinitionID,
           String activityID,
           int activityState,
           String actorID,
           String blockID,
           String durationLimit,
           String name,
           String processID,
           String startDate,
           String starterID,
           String updateDate) {
           this.activityDefinitionID = activityDefinitionID;
           this.activityID = activityID;
           this.activityState = activityState;
           this.actorID = actorID;
           this.blockID = blockID;
           this.durationLimit = durationLimit;
           this.name = name;
           this.processID = processID;
           this.startDate = startDate;
           this.starterID = starterID;
           this.updateDate = updateDate;
    }
    
    /**
     * jp.co.argo21.nautica.workflow.wfmc.Activity IuWFNg
     * CX^X𐶐B
     *
     * @param p jp.co.argo21.nautica.workflow.wfmc.Activity IuWFNg
     */
    public Activity(jp.co.argo21.nautica.workflow.wfmc.Activity wa) {
    	this(
    		wa.getActivityDefinitionID(), 
			wa.getActivityID(), 
			wa.getActivityState(), 
			wa.getActorID(), 
			wa.getBlockID(),
			df.format(new Date(wa.getDurationLimit().getTime())), 
			wa.getName(), 
			wa.getProcessID(), 
			df.format(new Date(wa.getStartDate().getTime())), 
			wa.getStarterID(), 
			df.format(new Date(wa.getUpdateDate().getTime())));
    }


	/**
	 * ANeBreB`ID擾B
	 *
	 * @return	ANeBreB`ID
	 */
    public String getActivityDefinitionID() {
        return activityDefinitionID;
    }


	/**
	 * ANeBreB`IDݒ肷B
	 *
	 * @param	ANeBreB`ID
	 */
    public void setActivityDefinitionID(String activityDefinitionID) {
        this.activityDefinitionID = activityDefinitionID;
    }


	/**
	 * ANeBreBCX^XID擾B
	 *
	 * @return	ANeBreBCX^XID
	 */
    public String getActivityID() {
        return activityID;
    }


	/**
	 * ANeBreBCX^XIDݒ肷B
	 *
	 * @param	actID	ANeBreBCX^XID
	 */
    public void setActivityID(String activityID) {
        this.activityID = activityID;
    }


	/**
	 * Ԃ擾B
	 *
	 * @return	
	 */
    public int getActivityState() {
        return activityState;
    }


	/**
	 * Ԃݒ肷B
	 *
	 * @param	actState	
	 */
    public void setActivityState(int activityState) {
        this.activityState = activityState;
    }

	/**
	 * sID擾B
	 *
	 * @return	sID
	 */
    public String getActorID() {
        return actorID;
    }

	/**
	 * sIDݒ肷B
	 *
	 * @param	actorID	sID
	 */
    public void setActorID(String actorID) {
        this.actorID = actorID;
    }


	/**
	 * subNID擾B
	 *
	 * @return	subNID
	 */
    public String getBlockID() {
        return blockID;
    }


	/**
	 * subNIDݒ肷B
	 *
	 * @param	blockID	subNID
	 */
    public void setBlockID(String blockID) {
        this.blockID = blockID;
    }


	/**
	 * s擾B
	 *
	 * @return	s
	 */
    public String getDurationLimit() {
        return durationLimit;
    }


	/**
	 * sݒ肷B
	 *
	 * @param	durationLimit	s
	 */
    public void setDurationLimit(String durationLimit) {
        this.durationLimit = durationLimit;
    }


	/**
	 * ANeBreBCX^X擾B
	 *
	 * @return	ANeBreBCX^X
	 */
    public String getName() {
        return name;
    }


	/**
	 * ANeBreBCX^Xݒ肷B
	 *
	 * @param	ANeBreBCX^X
	 */
    public void setName(String name) {
        this.name = name;
    }


	/**
	 * vZXCX^XID擾B
	 *
	 * @return	vZXCX^XID
	 */
    public String getProcessID() {
        return processID;
    }


	/**
	 * vZXCX^XIDݒ肷B
	 *
	 * @param	procID	vZXCX^XID
	 */
    public void setProcessID(String processID) {
        this.processID = processID;
    }


	/**
	 * Jn擾B
	 *
	 * @return	Jn
	 */
    public String getStartDate() {
        return startDate;
    }


	/**
	 * Jnݒ肷B
	 *
	 * @param	startDate	Jn
	 */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }


	/**
	 * Jn҂擾B
	 *
	 * @return	Jn
	 */
    public String getStarterID() {
        return starterID;
    }


	/**
	 * Jn҂ݒ肷B
	 *
	 * @param	starterID	Jn
	 */
    public void setStarterID(String starterID) {
        this.starterID = starterID;
    }


	/**
	 * ŐVԍXV擾B
	 *
	 * @return	ŐVԍXV
	 */
    public String getUpdateDate() {
        return updateDate;
    }


	/**
	 * ŐVԍXVݒ肷B
	 *
	 * @param	updateDate	ŐVԍXV
	 */
    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }
}
