/* $Id: ActivityState.java,v 1.7 2005/08/26 04:52:03 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;

/**
 * ANeBreBCX^X̏Ԃ SOAP bZ[W\킷NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityState  implements Serializable {

	private String stateString;
	
    /**
     * ANeBreBԂ𐶐B
    * 
    */
    public ActivityState() {
    	// ȂB
    }
    
    /**
     * ANeBreBԂ𐶐B
    * 
    * @param stateString Ԃ\킷
    */
    public ActivityState(String stateString) {
    	this.stateString = stateString;
    }
    
    /**
     * jp.co.argo21.nautica.workflow.wfmc.ActivityState
     * IuWFNgpāACX^X𐶐B
     *
     * @param state jp.co.argo21.nautica.workflow.wfmc.ActivityState IuWFNg
     */
    public ActivityState(
    		jp.co.argo21.nautica.workflow.wfmc.ActivityState state) {
    	this.stateString = state.toString();
    }
    
    /**
     * Ԃ̕\ԂB
     * 
     * @return Ԃ̕\
     */
    public String getStateString() {
        return stateString;
    }


    /**
     * Ԃ̕\ݒ肷B
     * 
     * @param stateInString Ԃ̕\
     */
    public void setStateString(String stateString) {
        this.stateString = stateString;
    }
    
    /**
     * jp.co.argo21.nautica.workflow.wfmc.ActivityState IuWFNgɕϊB
     * 
     * @return jp.co.argo21.nautica.workflow.wfmc.ActivityState IuWFNg
     */
    public jp.co.argo21.nautica.workflow.wfmc.ActivityState toWfmcActivityState() {

    	// Ԃ̕\ wfmc.ActivityState ̐sȂB
    	jp.co.argo21.nautica.workflow.wfmc.ActivityState state = null;
    	String stateString = this.getStateString();
    	if (stateString != null) {
    		if (stateString.equalsIgnoreCase("open.not_running.not_started")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(1);
    		
    		} else if (stateString.equalsIgnoreCase("open.not_running.suspended")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(2);
    		
    		} else if (stateString.equalsIgnoreCase("open.running")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(3);
    		
    		} else if (stateString.equalsIgnoreCase("closed.completed")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(4);
    		
    		} else if (stateString.equalsIgnoreCase("closed.terminated")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(5);
    		
    		} else if (stateString.equalsIgnoreCase("closed.aborted")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ActivityState.getState(6);
    		
    		} 
    	}
    	if (state == null) {
    		throw new IllegalStateException(
    				"Illegal StateString(StateString=" + stateString + ")");
    	}
    	
    	return state;
    }
}
