/* $Id: Attribute.java,v 1.7 2005/08/26 04:52:00 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;

import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;

/**
 * l SOAP bZ[W\NXłB
 * lɂ́AvZXϐ̂قɁA[U֘Af[^܂܂B
 * {[Nt[ŔF^́A^Al^A^l^łB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class Attribute implements Serializable {
	
	private int type;
	private String name;
	private String value;

    /**
     * 𐶐B
     *
     */
    public Attribute() {
    }

    /**
     * jp.co.argo21.nautica.workflow.wfmc.Attribute IuWFNg
     * ̃IuWFNg𐶐B
     *
     * @param attr jp.co.argo21.nautica.workflow.wfmc.Attribute IuWFNg
     */
    public Attribute(jp.co.argo21.nautica.workflow.wfmc.Attribute attr) {
    	this.setType(attr.getType());
    	this.setName(attr.getName());
    	this.setValue(attr.getValue());
    }
    
    /**
     *  jp.co.argo21.nautica.workflow.wfmc.Attribute IuWFNgԂB
     *
     * @return  jp.co.argo21.nautica.workflow.wfmc.Attribute IuWFNg
     */
    public jp.co.argo21.nautica.workflow.wfmc.Attribute toWfmcAttribute() {
        VariableBean attr = new VariableBean();
        attr.setName(this.getName());
        attr.setType(this.getType());
        attr.setValue(this.getValue());
        return attr;
    }
    
    /**
     * 𐶐B
     * 
     * @param name 
     * @param type ̌^
     * @param value l
     */
    public Attribute(String name, int type, String value) {
           this.name = name;
           this.type = type;
           this.value = value;
    }

    /**
     * ̂ԂB
     * 
     * @return name 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     * @param name 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * lԂB
     * 
     * @return value l
     */
    public String getValue() {
        return value;
    }

    /**
     * lݒ肷B
     * 
     * @param value l
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * ̌^ԂB
     * 
     * @return type ̌^
     */
    public int getType() {
        return type;
    }


    /**
     * ̌^ݒ肷B
     * 
     * @param type ̌^
     */
    public void setType(int type) {
        this.type = type;
    }
}
