/* $Id: Participant.java,v 1.7 2005/08/26 04:52:04 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;

import jp.co.argo21.nautica.workflow.dataaccess.OrganizationBean;
import jp.co.argo21.nautica.workflow.dataaccess.RoleBean;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;

/**
 * [Nt[Q҂ SOAP bZ[W\B
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class Participant  
	implements Serializable {
	
    private String ID;
    private String name;
    private int type;
    
    /**
     * [Nt[Q҂𐶐B
     *
     */
    public Participant() {
    }

    /**
     *  jp.co.argo21.nautica.workflow.wfmc.Participant IuWFNgԂB
     *
     * @return  jp.co.argo21.nautica.workflow.wfmc.Participant IuWFNg
     */
    public  jp.co.argo21.nautica.workflow.wfmc.Participant toWfmcParticipant() {
        // QҌ^e Participant IuWFNgɕϊāAԂB
        jp.co.argo21.nautica.workflow.wfmc.Participant participant = null;
        if (this.type == jp.co.argo21.nautica.workflow.wfmc.Participant.HUMAN) {
            UserBean user = new UserBean();
            user.setID(this.ID);
            participant = user;
            
        } else if (this.type == jp.co.argo21.nautica.workflow.wfmc.Participant.ORGANIZATIONAL_UNIT) {
            OrganizationBean org = new OrganizationBean();
            org.setID(this.ID);
            participant = org;
            
        } else if (this.type == jp.co.argo21.nautica.workflow.wfmc.Participant.ROLE) {
            RoleBean role = new RoleBean();
            role.setID(this.ID);
            participant = role;
            
        } else if (this.type == jp.co.argo21.nautica.workflow.wfmc.Participant.SYSTEM) {
            throw new IllegalArgumentException("Unsupported Paticipant Type: SYSTEM");
            
        } else {
            throw new IllegalArgumentException("Invalid Paticipant Type");
        }
        return participant;
    }
    
    /**
     * [Nt[Q҂𐶐B
     *
     * @param ID QID
     * @param allAttributeNames ێ鑮
     * @param name QҖ
     * @param type QҌ^
     */
    public Participant(
           String ID,
           String name,
           int type) {
           this.ID = ID;
           this.name = name;
           this.type = type;
    }


    /**
     * Q ID ԂB 
     * 
     * @return QID
     */
    public String getID() {
        return ID;
    }


    /**
     * QID ݒ肷B
     * 
     * @param QID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /**
     *QҖ̂
     * 
     * @return name
     */
    public String getName() {
        return name;
    }


    /**
     * QҖ̂ݒ肷B
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * QҌ^ԂB
     * 
     * @return type QҌ^
     */
    public int getType() {
        return type;
    }


    /**
     * QҌ^ݒ肷B
     * 
     * @param type QҌ^
     */
    public void setType(int type) {
        this.type = type;
    }
    
	/**
	 * ێ邷ׂĂ̑ԂB
	 * SOAPbZ[WƂĂ͂̃\bhT|[gȂB
	 *
	 * @return ̈ꗗ
	 */
	public String[] getAllAttributeNames() {
		throw new UnsupportedOperationException(
				"SOAPbZ[WƂĂ͂̃\bhT|[g܂");
	}

	/**
	 * ێ鑮ԂB
	 * SOAPbZ[WƂĂ͂̃\bhT|[gȂB
	 *
	 * @param name 
	 * @return l
	 */
	public String getAttribute(String arg0) {
		throw new UnsupportedOperationException(
				"SOAPbZ[WƂĂ͂̃\bhT|[g܂");
	}

	/**
	 * ݒ肷B
	 * SOAPbZ[WƂĂ͂̃\bhT|[gȂB
	 *
	 * @param name 
	 * @param value l
	 */
	public void setAttribute(String arg0, String arg1) {
		throw new UnsupportedOperationException(
				"SOAPbZ[WƂĂ͂̃\bhT|[g܂");
	}
}
