/* $Id: Process.java,v 1.6 2005/08/26 04:52:01 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

/**
 * vZXCX^X SOAP bZ[W\NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class Process  implements Serializable {
    private String ID;
    private String durationLimit;
    private String name;
    private String packageID;
    private String procDefinitionID;
    private int processState;
    private String startDate;
    private String starterID;
    private String updateDate;

    private static final DateFormat df = DateFormat.getDateInstance();
    
    /**
     * vZXCX^X𐶐B
     *
     */
    public Process() {
    }

    /**
     * vZXCX^X𐶐B
     *
     * @param ID vZXCX^XID
     * @param durationLimit s
     * @param name vZXCX^X
     * @param packageID pbP[WID
     * @param procDefinitionID vZX`ID
     * @param processState 
     * @param startDate Jn
     * @param starterID Jn
     * @param updateDate ŐVԍXV
     */
    public Process(
           String ID,
           String durationLimit,
           String name,
           String packageID,
           String procDefinitionID,
           int processState,
           String startDate,
           String starterID,
           String updateDate) {
           this.ID = ID;
           this.durationLimit = durationLimit;
           this.name = name;
           this.packageID = packageID;
           this.procDefinitionID = procDefinitionID;
           this.processState = processState;
           this.startDate = startDate;
           this.starterID = starterID;
           this.updateDate = updateDate;
    }

    /**
     * jp.co.argo21.nautica.workflow.wfmc.Process IuWFNg
     * CX^X𐶐B
     *
     * @param p jp.co.argo21.nautica.workflow.wfmc.Process IuWFNg
     */
    public Process(jp.co.argo21.nautica.workflow.wfmc.Process wp) {
    	this(
    		wp.getID(), 
    		df.format(new Date(wp.getDurationLimit().getTime())), 
			wp.getName(), 
			wp.getPackageID(), 
			wp.getProcDefinitionID(), 
			wp.getProcessState(), 
			df.format(new Date(wp.getStartDate().getTime())), 
			wp.getStarterID(), 
			df.format(new Date(wp.getUpdateDate().getTime())));
    }
    
    /**
     * vZXCX^X ID ԂB
     * 
     * @return ID vZXCX^XID
     */
    public String getID() {
        return ID;
    }


    /**
     * vZXCX^X ID ݒ肷B
     * 
     * @param ID vZXCX^XID
     */
    public void setID(String ID) {
        this.ID = ID;
    }


    /**
     * sԂB
     * 
     * @return durationLimit s
     */
    public String getDurationLimit() {
        return durationLimit;
    }


    /**
     * sݒ肷B
     * 
     * @param durationLimit s
     */
    public void setDurationLimit(String durationLimit) {
        this.durationLimit = durationLimit;
    }


    /**
     * vZXCX^XԂB
     * 
     * @return name vZXCX^X
     */
    public String getName() {
        return name;
    }


    /**
     * vZXCX^Xݒ肷B
     * 
     * @param name vZXCX^X
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * pbP[W ID ԂB
     * 
     * @return packageID pbP[WID
     */
    public String getPackageID() {
        return packageID;
    }


    /**
     * pbP[W ID ݒ肷B
     * 
     * @param packageID pbP[WID
     */
    public void setPackageID(String packageID) {
        this.packageID = packageID;
    }


    /**
     * vZX` ID ԂB
     *  
     * @return procDefinitionID vZX`ID
     */
    public String getProcDefinitionID() {
        return procDefinitionID;
    }


    /**
     * vZX` ID ݒ肷B
     * 
     * @param procDefinitionID vZX`ID
     */
    public void setProcDefinitionID(String procDefinitionID) {
        this.procDefinitionID = procDefinitionID;
    }


    /**
     * ԂԂB
     * 
     * @return processState 
     */
    public int getProcessState() {
        return processState;
    }


    /**
     * Ԃݒ肷B
     * 
     * @param processState 
     */
    public void setProcessState(int processState) {
        this.processState = processState;
    }


    /**
     * JnԂB
     * 
     * @return startDate Jn
     */
    public String getStartDate() {
        return startDate;
    }


    /**
     * Jnݒ肷B
     * 
     * @param startDate Jn
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }


    /**
     * Jn҂ԂB
     * 
     * @return starterID Jn
     */
    public String getStarterID() {
        return starterID;
    }


    /**
     * Jn҂ԂB
     * 
     * @param starterID Jn
     */
    public void setStarterID(String starterID) {
        this.starterID = starterID;
    }


    /**
     * ŐVԍXVԂB
     * 
     * @return updateDate ŐVԍXV
     */
    public String getUpdateDate() {
        return updateDate;
    }


    /**
     * ŐVԍXVݒ肷B
     * 
     * @param updateDate ŐVԍXV
     */
    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }
}
