/* $Id: ProcessDefinitionState.java,v 1.7 2005/08/26 04:52:06 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.soap.message;

import java.io.Serializable;

/**
 * vZX`̏Ԃ\IuWFNg SOAP bZ[W\킷NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDefinitionState implements Serializable {

	private String stateString;
	
	/**
	 * vZX`̏Ԃ\IuWFNg𐶐B
	 *
	 */
    public ProcessDefinitionState() {
    }
    
	/**
	 * vZX`̏Ԃ\IuWFNg𐶐B
	 * 
	 * @param stateString Ԃ\킷
	 */
    public ProcessDefinitionState(String stateString) {
    	this.stateString = stateString;
    }
    
    /**
     * jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState 
     * IuWFNgpāACX^X𐶐B
     *
     * @param state jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg
     */
    public ProcessDefinitionState(
    		jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState state) {
    	this.stateString = state.toString();
    }
    
    /**
     * Ԃ̕\ԂB
     * 
     * @return Ԃ̕\
     */
    public String getStateString() {
        return stateString;
    }


    /**
     * Ԃ̕\ݒ肷B
     * 
     * @param stateInString Ԃ̕\
     */
    public void setStateString(String stateString) {
        this.stateString = stateString;
    }
    
    /**
     * jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNgɕϊB
     * 
     * @return jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState IuWFNg
     */
    public jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState toWfmcProcessDefinitionState() {
    	
    	// Ԃ̕\ wfmc.ProcessDefinitionState ̐sȂB
    	jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState state = null;
    	String stateString = this.getStateString();
    	if (stateString != null) {
    		if (stateString.equalsIgnoreCase("enable")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState.getState(1001);
    		} else if (stateString.equalsIgnoreCase("disable")) {
    			state = jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState.getState(1002);
    		}
    	}
    	if (state == null) {
    		throw new IllegalStateException(
    				"Illegal StateString(StateString=" + stateString + ")");
    	}
    	return state;
    }

}
