/* $Id: BooleanDocument.java,v 1.3 2005/08/26 04:48:48 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import javax.swing.text.*;

/**
 * ^l͗ptB[ĥ߂̐sB
 * ̃hLggƁA`t'L[͂ƁA`true'\A
 * `f'L[͂ƁA`false'\B
 * JTextFIeldɑ΂āAݒsƂłB
 * 
 * <pre>
 * JTextField f = new JTextField();
 * f.setDocument(new BooleanDocument());
 * </pre>
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class BooleanDocument extends PlainDocument
{
	static private final String TRUE  = "true";
	static private final String FALSE = "false";

	/**
	 * ^l͐phLgIuWFNg𐶐B
	 */
	public BooleanDocument()
	{
	}

	/**
	 * }̐sB
	 *
	 * @param offset }ʒu
	 * @param s      }
	 * @param a      l
	 * @throws BadLocationException w肳ꂽ}̈ʒuAhLg̗LȈʒuł͂Ȃꍇ
	 */
	public void insertString(int offset, String s, AttributeSet a) throws BadLocationException
	{
		if (s == null) return;
		
		String v = null;
		char[] chars = s.toCharArray();
		int max = chars.length;
		for (int i = 0; i < max; i++) {
			char c = chars[i];
			switch (c) {
				case 'T':
				case 't':
					v = TRUE;
					break;
				case 'F':
				case 'f':
					v = FALSE;
					break;
			}
		}
		if (v == null) return;

		this.remove(0, getLength());
		super.insertString(0, v, a);
	}
}
