/* $Id: DialogUtilities.java,v 1.3 2005/08/26 04:48:49 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.*;

/**
 * {_CAO̊ȈՕ\p̃[eBeB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public final class DialogUtilities
{
	/** ohpX */
	static private final String path = "jp.co.argo21.commons.resources.commons";

	/** \[Xoh */
	static private ResourceBundle resources;

	static
	{
		try {
			resources = ResourceBundle.getBundle(path);
		} catch (MissingResourceException ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * w肳ꂽAplƂĕ\B
	 *
	 * @param	message 
	 */
	public static final void showInfo(String message)
	{
		JOptionPane.showMessageDialog(
				null,
				message,
				resources.getString("DialogUtilities.info"),
				JOptionPane.INFORMATION_MESSAGE
			);
	}

	/**
	 * w肳ꂽAG[plƂĕ\B
	 *
	 * @param	message 
	 */
	public static final void showError(String message)
	{
		JOptionPane.showMessageDialog(
				null,
				message,
		        resources.getString("DialogUtilities.error"),
				JOptionPane.ERROR_MESSAGE
			);
	}

	/**
	 * w肳ꂽAxplƂĕ\B
	 *
	 * @param	message 
	 */
	public static final void showWarning(String message)
	{
		JOptionPane.showMessageDialog(
				null,
				message,
				resources.getString("DialogUtilities.warning"),
				JOptionPane.WARNING_MESSAGE
			);
	}

	/**
	 * w肳ꂽAOK_CANCEL_OPTIONtmFplƂĕ\B
	 *
	 * @param	message 
	 */
	public static final int showOkCancelConfirm(String message)
	{
		return JOptionPane.showConfirmDialog(
				null,
				message,
				resources.getString("DialogUtilities.confirm"),
				JOptionPane.OK_CANCEL_OPTION,
				JOptionPane.QUESTION_MESSAGE
			);
	}

	/**
	 * w肳ꂽAYES_NO_OPTIONtmFplƂĕ\B
	 *
	 * @param	message 
	 */
	public static final int showYesNoConfirm(String message)
	{
		return JOptionPane.showConfirmDialog(
				null,
				message,
				resources.getString("DialogUtilities.confirm"),
				JOptionPane.YES_NO_OPTION,
				JOptionPane.QUESTION_MESSAGE
			);
	}

	/**
	 * w肳ꂽAYES_NO_CANCEL_OPTIONtmFplƂĕ\B
	 *
	 * @param	message 
	 */
	public static final int showYesNoCanelConfirm(String message)
	{
		return JOptionPane.showConfirmDialog(
				null,
				message,
				resources.getString("DialogUtilities.confirm"),
				JOptionPane.YES_NO_CANCEL_OPTION,
				JOptionPane.QUESTION_MESSAGE
			);
	}
}
