/* $Id: ExceptionFrame.java,v 1.3 2005/08/26 04:48:46 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

/**
 * vꂽÕX^bNg[X\邽߂̗Or[AB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public final class ExceptionFrame extends JInternalFrame
{
	static private final String BUNDLE_PATH
		= "jp.co.argo21.commons.resources.commons";
	static private SimpleDateFormat formatter
		= new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS =======================================\n");
	static private ResourceBundle resources;

	private JPanel       panel       = new JPanel();
	private JTextArea    codeArea    = new JTextArea();
	private JScrollPane  scrollPane  = new JScrollPane();
	private JPanel       buttonPanel = new JPanel();
	private JButton      clearButton = new JButton();
	private JButton      closeButton = new JButton();
	private BorderLayout layout      = new BorderLayout();

	private boolean isExit = false;

	static
	{
		try {
			resources = ResourceBundle.getBundle(BUNDLE_PATH);
		} catch (MissingResourceException ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * Or[A𐶐B
	 */
	public ExceptionFrame()
	{
		super(getResourceString("ExceptionViewer.title", "Exception Viewer"), false, true);
		this.setLayer(JLayeredPane.POPUP_LAYER);

		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = new Dimension((int)(screenSize.width * 0.8), (int)(screenSize.height * 0.8));
		setBounds(
			(screenSize.width - frameSize.width) / 2,
			(screenSize.height - frameSize.height) / 2,
			frameSize.width,
			frameSize.height
			);

		panel.setLayout(layout);
		panel.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 204), 4));

		codeArea.setBorder(BorderFactory.createLoweredBevelBorder());
		codeArea.setEditable(false);

		JViewport viewport = scrollPane.getViewport();
		viewport.add(codeArea, null);

		buttonPanel.setOpaque(false);

		clearButton.setText(getResourceString("ExceptionViewer.clearButton.text", "Clear"));
		clearButton.setRolloverEnabled(true);
		clearButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				clear();
			}
		});
		buttonPanel.add(clearButton, null);

		closeButton.setText(getResourceString("ExceptionViewer.closeButton.text", "Close"));
		closeButton.setRolloverEnabled(true);
		closeButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				close();
			}
		});
		buttonPanel.add(closeButton, null);

		panel.add(scrollPane, BorderLayout.CENTER);
		panel.add(buttonPanel, BorderLayout.SOUTH);

		setContentPane(panel);
	}

	/**
	 * \Oݒ肷B
	 *
	 * @param throwable O
	 */
	public void setThrowable(Throwable throwable)
	{
		if (throwable == null) return;

		//lXgĂThrowableċA
		setThrowable(throwable.getCause());

		int len = codeArea.getText().length();
		codeArea.setCaretPosition(len);

		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw, true);
		throwable.printStackTrace(pw);
		String trace = sw.toString();
		pw.close();


		Date date = new Date();
		codeArea.append(formatter.format(date));
		codeArea.append(trace);
		codeArea.append("\n");
		codeArea.setCaretPosition(len);

		repaint();
	}


	/**
	 * \郁bZ[Wݒ肷B
	 *
	 * @param message bZ[W
	 */
	public void setMessage(String message)
	{
		if (message == null) return;

		int len = codeArea.getText().length();
		codeArea.setCaretPosition(len);

		Date date = new Date();
		codeArea.append(formatter.format(date));
		codeArea.append(message);
		codeArea.append("\n");

		repaint();
	}

	/**
	 * O\GANAB
	 */
	private void clear()
	{
		codeArea.setText("");
	}

	/**
	 * r[AB
	 */
	private void close()
	{
		setVisible(false);

		if (isExit) {
			System.exit(0);
		}
	}

	/**
	 * OnhOŃ\[XANZXB
	 */
	static private String getResourceString(String key, String alt)
	{
		try {
			return resources.getString(key);
		} catch (Exception ex) {
			return alt;
		}
	}
}
