/* $Id: Grid.java,v 1.3 2005/08/26 04:48:45 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.awt.*;

/**
 * Obh@\B
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */

public class Grid
{
    /**
     * w肳ꂽWlAw肳ꂽObhŕ␳B
     *
     * @param	p	Wl
     * @param	spacing	Obh
     * @return	␳ꂽWl
     */
    static public Point snap(Point p, int spacing)
    {
		if (spacing <= 0) return null;
		return new Point(
			(p.x + (spacing / 2)) / spacing * spacing,
			(p.y + (spacing / 2)) / spacing * spacing
			);
	}

	/**
	 * w肳ꂽOtBbNR|[lgɁAw肳ꂽObh
	 * Obh`悷B
	 *
	 * @param	c	`Ώۂ̃R|[lg
	 * @param	g	`Ώۂ̃OtBbNX
	 * @param	spacing	Obh
	 */
	static public void draw(Component c, Graphics g, Dimension spacing)
	{
		if (spacing == null) return;

		Shape clip = g.getClip();
		Rectangle r = c.getBounds();

		g.setColor(Color.lightGray);

		g.clipRect(0, 0, r.width, r.height);

		for (int i = 0; i < r.height; i += spacing.height)
			g.drawLine(0, i, r.width, i);

		for (int i = 0; i < r.width; i += spacing.width)
			g.drawLine(i, 0, i, r.height);

		g.setClip(clip);
	}

	/**
	 * w肳ꂽOtBbNR|[lgɁAw肳ꂽObh
	 * Obh`悷B
	 *
	 * @param	c	`Ώۂ̃R|[lg
	 * @param	g	`Ώۂ̃OtBbNX
	 * @param	spacing	Obh
	 */
	static public void draw(Component c, Graphics g, int spacing)
	{
		if (spacing <= 0) return;

		Shape clip = g.getClip();
		Rectangle r = c.getBounds();

		g.setColor(Color.lightGray);

		g.clipRect(0, 0, r.width, r.height);

		for (int i = 0; i < r.height; i += spacing)
			g.drawLine(0, i, r.width, i);

		for (int i = 0; i < r.width; i += spacing)
			g.drawLine(i, 0, i, r.height);

		g.setClip(clip);
	}

	/**
	 * w肳ꂽ`͈͂ɁAw肳ꂽObh
	 * Obh`悷B
	 *
	 * @param	r	`Ώۂ̋`͈
	 * @param	g	`Ώۂ̃OtBbNX
	 * @param	spacing	Obh
	 */
	static public void draw(Rectangle r, Graphics g, Dimension spacing)
	{
		if (spacing == null) return;

		g.setColor(Color.lightGray);

		for (int i = r.y; i <= (r.y + r.height); i += spacing.height)
			g.drawLine(r.x, i, r.x + r.width, i);

		for (int i = r.x; i <= (r.x + r.width); i += spacing.width)
			g.drawLine(i, r.y, i, r.y + r.height);
	}

	/**
	 * w肳ꂽ`͈͂ɁAw肳ꂽObh
	 * Obh`悷B
	 *
	 * @param	r	`Ώۂ̋`͈
	 * @param	g	`Ώۂ̃OtBbNX
	 * @param	spacing	Obh
	 */
	static public void draw(Rectangle r, Graphics g, int spacing)
	{
		if (spacing <= 0) return;

		g.setColor(Color.lightGray);

		for (int i = r.y; i <= (r.y + r.height); i += spacing)
			g.drawLine(r.x, i, r.x + r.width, i);

		for (int i = r.x; i <= (r.x + r.width); i += spacing)
			g.drawLine(i, r.y, i, r.y + r.height);
	}
}
