/* $Id: HelpFrame.java,v 1.4 2005/08/26 04:48:50 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.JInternalFrame;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/**
 * wvr[ABwvt@CHTMLƂċLqB
 * wveLڂHTMLt@Cjarɂ܂Ƃ߂ĂA
 * CLASSPATHɒʂƂŗeՂɃANZX\ɂȂB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class HelpFrame extends JInternalFrame
{
	static private final String BUNDLE_PATH
		= "jp.co.argo21.commons.resources.commons";
	static private String PAGE_NOT_FOUND;
	static private ResourceBundle resources;

	private JList       helpList;
	private BrowserPane browserPane;

	static
	{
		try {
			resources = ResourceBundle.getBundle(BUNDLE_PATH);
			PAGE_NOT_FOUND = resources.getString("HelpViewer.nopage");
		} catch (MissingResourceException ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * wvr[A\zB
	 *
	 * @param path \[Xoh̃pX
	 */
	public HelpFrame()
	{
		super(
			resources.getString("HelpViewer.title"),
			true, //TCY
			true, //N[Y
			true, //ő剻
			true);//ŏ

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int sw = screen.width;
		int sh = screen.height;
		Dimension size = new Dimension(500, (int)(sh * 0.90));
		this.setSize(size);
		this.setLocation(sw - size.width, 0);

		browserPane = new BrowserPane();
		this.setContentPane(browserPane);
		this.validate();
	}

	/**
	 * w肳ꂽ\[XuEUɃ[hB
	 *
	 * @param s \[XpX
	 */
	public void loadResource(String path)
	{
		URL url = null;
		if (path != null) url = HelpFrame.class.getResource(path);
		if (url == null) url = HelpFrame.class.getResource(PAGE_NOT_FOUND);
		browserPane.loadURL(url);
	}

	/**
	 * w肳ꂽURLuEUɃ[hB
	 *
	 * @param urlpath URL
	 */
	public void loadURL(String urlpath)
	{
		URL url = null;
		try {
			url = new URL(urlpath); 
		} catch (Exception ex) {
			url = HelpFrame.class.getResource(PAGE_NOT_FOUND);
		}
		browserPane.loadURL(url);
	}

	/**
	 * w肳ꂽURLuEUɃ[hB
	 *
	 * @param url URL
	 */
	public void loadURL(URL url)
	{
		if (url == null) url = HelpFrame.class.getResource(PAGE_NOT_FOUND);
		browserPane.loadURL(url);
	}

	/**
	 * wvuEŨuEUNXłB
	 *
	 * @author  ARGO21 Corp.
	 * @version $Revision: 1.4 $
	 * @since   Nautica Workflow 0.9
	 */
	private final class BrowserPane extends JScrollPane
	implements HyperlinkListener
	{
		/**
		 * uEU\
		 */
		private JEditorPane browser;

		/**
		 * uEŨCX^X𐶐B
		 */
		private BrowserPane()
		{
			browser = new JEditorPane();
			browser.setEditable(false);
			browser.addHyperlinkListener(this);

			JViewport vp = getViewport();
			vp.add(browser);
		}

		/**
		 * nCp[eLXgNXVꂽƂɌĂяoB
		 *
		 * @param e XVCxg
		 * @see javax.swing.event.HyperlinkListener
		 */
		public void hyperlinkUpdate(HyperlinkEvent e)
		{
			if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				linkActivated(e.getURL());
			}
		}

		/**
		 * w肳ꂽURLuEUɃ[hB
		 *
		 * @param u URL
		 */
		public void loadURL(URL u)
		{
			SwingUtilities.invokeLater(new PageLoader(u));
		}

		/**
		 * NLɂȂƂʒmB
		 *
		 * @param u URL
		 */
		private void linkActivated(URL u)
		{
			SwingUtilities.invokeLater(new PageLoader(u));
		}

		/**
		 * y[W[hXbhNXłB
		 *
		 */
		private final class PageLoader implements Runnable
		{
			/**
			 * URL
			 */
			private URL url;

			/**
			 * y[W[_̃CX^X𐶐B
			 *
			 * @param u URL
			 */
			PageLoader(URL u) {
				url = u;
			}

			/**
			 * y[W[hB
			 */
			public void run() {
				if (url == null) {
					Container parent = browser.getParent();
					parent.repaint();
				} else {
					javax.swing.text.Document doc = browser.getDocument();
					try {
						browser.setPage(url);
					} catch (IOException ioe) {
						browser.setDocument(doc);
					} finally {
						url = null;
						SwingUtilities.invokeLater(this);
					}
				}
			}
		}
	}
}
