/* $Id: Splash.java,v 1.3 2005/08/26 04:48:47 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

/**
 * ėp̃o[W\ʂłBʂ̕\ʒúAXN[ɔzuA
 * ʂ̑傫̓[h郍SC[W̃TCYɂȂB
 * ʉɂ̓o[Wƒ쌠\\̂ŁA
 * gpC[WƕFɂĂ͌Â炭ȂꍇlB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
final public class Splash extends JWindow
{
	/**
	 * o[W\ʂ𐶐B
	 *
	 * @param path      iSC[W\[XpX
	 * @param copyright 쌠\
	 * @param version   o[W
	 * @param color     F
	 */
	public Splash(String path, String copyright, String version, Color color)
	{
		super();
		VersionPanel panel = new VersionPanel(path, copyright, version, color);

		panel.addMouseListener(
			new MouseAdapter() {
				public void mouseReleased(MouseEvent e) {
					Splash.this.hide();
				}
			}
		);
		setContentPane(panel);
		pack();
	}

	/**
	 * o[W\ʂ𒆉ɕ\B
	 */
	public void show()
	{
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension size = getSize();
		setBounds(
			(screenSize.width - size.width) / 2,
			screenSize.height / 4,
			size.width,
			size.height
			);

		super.show();
	}
}
