/* $Id: VersionPanel.java,v 1.3 2005/08/26 04:48:50 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.commons.swing;

import java.awt.*;
import javax.swing.JPanel;

/**
 * o[W\pplłB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class VersionPanel extends JPanel
{
	/** iSC[W */
	private Image logo;

	/** 쌠\ */
	private String copyright = "";

	/** o[W\ */
	private String version = "";

	/** F */
	private Color color = Color.black;

	/**
	 * o[W\pGA𐶐B
	 * 
	 * @param path      iSC[W\[XpX
	 * @param version   o[W
	 * @param copyright 쌠\
	 * @param color     F
	 */
	public VersionPanel(String path, String version, String copyright, Color color)
	{
		super();

		this.version = ((version != null)? version : "");
		this.copyright = ((copyright != null)? copyright : "");
		this.color = ((color!= null)? color : Color.black);

		try {
			logo = Toolkit.getDefaultToolkit().getImage(getClass().getResource(path));

			// C[WSɃ[h܂ő҂B
			MediaTracker tracker = new MediaTracker(this);
			tracker.addImage(logo, 0);
			tracker.waitForID(0);

			// \GA[hC[W̃TCYɂ킹B
			Dimension size =
				new Dimension(logo.getWidth(this), logo.getHeight(this));
			this.setPreferredSize(size);
		} catch (Exception ex) {
			logo = null;
			this.setPreferredSize(new Dimension(350, 250));
		}
	}

	/**
	 * o[W\`悷B
	 *
	 * @param	g	`ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		//wiƂȂ郍SC[W`悷B
		if (logo != null) g.drawImage(logo, 0, 0, this);

		Dimension size = this.getSize();
		Font f = new Font("SansSerif", Font.BOLD, 12);
		FontMetrics metrics = g.getFontMetrics(f);
		int height = metrics.getHeight();
		int descent = metrics.getDescent();

		g.setColor(color);
		g.setFont(f);

		//o[W`悷B
		if (version != null) {
			int width = metrics.stringWidth(version);
			int dx = (size.width - width) / 2;
			int dy = size.height - (height + descent + 20);
			g.drawString(version, dx, dy);
		}

		//Rs[Cg`悷B
		if (copyright != null) {
			int width = metrics.stringWidth(copyright);
			int dx = (size.width - width) / 2;
			int dy = size.height - (descent + 10);
			g.drawString(copyright, dx, dy);
		}
	}
}
