/* $Id: DefinitionRegister.java,v 1.5 2005/08/26 04:55:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;

/**
 * [Nt[VXe^pՂւ̒`o^pNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class DefinitionRegister
{
	/** O */
	static private final Logger log = Logger.getLogger(DefinitionRegister.class);

	/** o[W */
	static private final String version = "0.9";

	/** l[~OURL */
	static private String naming = "iiop://localhost:1050";
	/** XR[v */
	static private String scope = "";
	/** [U */
	static private String user = "";
	/** pX[h */
	static private String pass = "";
	/** Ǘ҃L[ */
	static private String adminKey = "";
	/** ` */
	static private String defName = "";
	/** `t@C΃pX */
	static private String defPath = "";
	

	/**
	 * [Nt[VXe^pՂւ̒`o^pmain\bhłB
	 *
	 * @param	args	N̈
	 */
	static public void main(String[] args)
	{
		try {
			parseOption(args);
	        WorkflowServiceAccessor accessor 
				= new WorkflowServiceAccessor(
						new ConnectionInfo(naming, scope, user, pass));
	        String session = accessor.open();
			WorkflowAdminHandlerRemote handler = accessor.getWorkflowAdminHandler();
			handler.registerDefinition(session, defName, defPath);
		} catch (Exception ex) {
			DefinitionRegister.exitWithException(ex);
		}
	}

	/**
	 * ̔sB
	 * 
	 * @param	args	N̈
	 */
	static private void parseOption(String[] args)
	{
 		int argc = args.length;
		if (argc < 1) usage(null);

		int i = 0;
		while (i < argc) {
			String token = args[i];

			if (token.equals("-jndi")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				naming = args[i];
			} else if (token.equals("-scope")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				scope = args[i];
			} else if (token.equals("-u")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				user = args[i];
			} else if (token.equals("-p")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				pass = args[i];
			} else if (token.equals("-admin")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				adminKey = args[i];
			} else if (token.equals("-v")) {
				version();
			} else if (token.equals("-h")) {
				usage(null);
			} else if (token.startsWith("-")) {
				usage("Unknown option.: " + token);
			} else {
				break;
			}
			i++;
		}
		if (i == argc) usage("Invalid usage");
		defName = args[i];
		i++;
		if (i == argc) usage("Invalid usage");
		defPath = args[i];
	}

	/**
	 * gp@̕\
	 *
	 * @param message G[bZ[WBnullB
	 */
	static private void usage(String message)
	{
		if (message != null) System.err.println(message);

		System.err.println(
			"DefinitionRegister " + version + "\n"
			+ "Copyright (c)2005 ARGO 21, Corp. All rights reserved.\n"
			+ "Usage: java [<java options>...] "
			+ DefinitionRegister.class.getName() + "\n"
			+ "            [<OPTIONS>] <def_name> <def_path>\n\n"
			+ " OPTIONS:\n"
			+ "   -jndi <naming_url>\n"
            + "                    Naitica Workflow naming url.\n"
			+ "   -scope <scope>\n"
            + "                    Naitica Workflow naming scope.\n"
			+ "   -u <user>\n"
            + "                    Naitica Workflow user.\n"
			+ "   -p <password>\n"
            + "                    Naitica Workflow password.\n"
			+ "   -admin <admin_key>\n"
            + "                    Naitica Workflow admin key.\n"
			+ "   -v               print version.\n"
			+ "   -h               print this message.\n"
			);

		System.exit(1);
    }

	/**
	 * o[W̕\
	 */
	static private void version()
	{
		System.err.println("DefinitionRegister version " + version);
		System.exit(0);
    }
	
	/**
	 * [Nt[VXe^pՂւ̒`o^ssB
	 * 
	 * @param ex Cӂ̗O
	 */
	static private void exitWithException(Exception ex)
	{
		log.error("DefinitionRegister failed.", ex);
		ex.printStackTrace();

		System.exit(1);
	}
}
