/* $Id: WorkflowEngineStarter.java,v 1.7 2005/08/26 04:55:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngineConstants;

/**
 * [Nt[VXe^pՂ̋NpNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowEngineStarter
{
	/** o[W */
	static private final String version = "0.9";

	/** Ǘ҃L[ */
	static private String adminKey;

	/**
	 * [Nt[VXe^pՃ[hpmain\bhłB
	 *
	 * @param	args	N̈
	 */
	static public void main(String[] args)
	{
		try {
			parseOption(args);
			WorkflowEngine.boot(adminKey);
		} catch (Exception ex) {
			WorkflowEngineStarter.shutdownWithException(ex);
		}
	}

	/**
	 * ̔sB
	 * 
	 * @param	args	N̈
	 */
	static private void parseOption(String[] args)
	{
 		int argc = args.length;
		if (argc < 1) usage(null);

		int i = 0;
		while (i < argc) {
			String token = args[i];

			if (token.equals("-home")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);

				String path = args[i];
				System.setProperty(WorkflowEngineConstants.NAUTICA_HOME, path);
			} else if (token.equals("-admin")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				adminKey = args[i];
			} else if (token.equals("-v")) {
				version();
			} else if (token.equals("-h")) {
				usage(null);
			} else if (token.startsWith("-")) {
				usage("Unknown option.: " + token);
			} else {
				break;
			}
			i++;
		}
	}

	/**
	 * gp@̕\
	 *
	 * @param message G[bZ[WBnullB
	 */
	static private void usage(String message)
	{
		if (message != null) System.err.println(message);

		System.err.println(
			"WorkflowEngineStarter " + version + "\n"
			+ "Copyright (c)2005 ARGO 21, Corp. All rights reserved.\n"
			+ "Usage: java [<java options>...] "
			+ WorkflowEngineStarter.class.getName() + "\n"
			+ "            [-home <nautica_home_dir>]\n\n"
			+ " OPTIONS:\n"
			+ "   -home <nautica_home_dir>\n"
            + "                    Naitica Workflow home directory path.\n"
			+ "   -admin <admin_key>\n"
            + "                    Naitica administrator key.\n"
			+ "   -v               print version.\n"
			+ "   -h               print this message.\n"
			);

		System.exit(1);
    }

	/**
	 * o[W̕\
	 */
	static private void version()
	{
		System.err.println("WorkflowEngineStarter version " + version);
		System.exit(0);
    }
	
	/**
	 * [Nt[VXe^pՂ̃u[gssB
	 * 
	 * @param ex Cӂ̗O
	 */
	static private void shutdownWithException(Exception ex)
	{
		ex.printStackTrace();
		System.exit(1);
	}
}
