/* $Id: ConnectionInfo.java,v 1.6 2005/08/26 04:55:51 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.client;

/**
 * NCAggpڑB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ConnectionInfo {

	/** GW */
	private String engineName;
	/** XR[v */
	private String scope;
	/** [UID */
	private String userID;
	/** pX[h */
	private String password;

	/**
	 * ڑ𐶐B
	 * GWڑɂ́Al[~OT[rXURLB
	 * URĹA"iiop://zXg:|[gԍ"Ƃ`Ƃ̂ƂB
	 * [J}Vɑ΂ڑɂƂƁAGWڑ
	 * "iiop://127.0.0.1:1050"ƂlƂȂB
	 * XR[v́A{[Nt[VXe^pՂł͊{IɎgpȂB
	 * lݒ肳Ăꍇ́Al[~OT[rXɃANZXۂ́A
	 * TuReLXgƂĕ⊮sB
	 * Ȃ킿A"foo"ݒ肳ĂꍇAReLXgɑ΂āA
	 * "foo/WorkflowServiceManagerRemote"̂ƂB
	 *
	 * @param engineName GWڑ
	 * @param scope XR[v
	 * @param user [UID
	 * @param pass pX[h
	 */
	public ConnectionInfo(String engineName, String scope,
			String user, String pass) {
	    this.engineName = engineName;
	    this.scope = scope;
	    this.userID = user;
	    this.password = pass;
	}
	
	/**
	 * GWڑԂB
	 *
	 * @return GWڑ
	 */
	public String getEngineName() {

		return engineName;
	}

	/**
	 * XR[vԂB
	 *
	 * @return XR[v
	 */
	public String getScope() {

		return scope;
	}

	/**
	 * [UIDԂB
	 *
	 * @return [UID
	 */
	public String getUserID() {

		return userID;
	}

	/**
	 * pX[hԂB
	 *
	 * @return password̒l
	 */
	public String getPassword() {

		return password;
	}
	
	/**
	 * ڑ̕\Ԃ
	 * 
	 * @return	ڑ̕\
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
	    StringBuffer buf = new StringBuffer("[GW=");
	    buf.append(this.engineName).append("]");
	    buf.append("[XR[v=").append(this.scope).append("]");
	    buf.append("[[UID=").append(this.userID).append("]");
	    buf.append("[pX[h=").append(this.password).append("]");
	    return new String(buf);
	}
}
