/* $Id: WorkflowServiceAccessor.java,v 1.12 2005/08/26 04:55:50 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.client;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.ServiceNames;
import jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * [Nt[T[rXANZbT́A[Nt[GWɑ΂
 * NCAgCułB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowServiceAccessor {

    /** Oo̓IuWFNg */
    private Logger log = Logger.getLogger(this.getClass());
    
    /** [Nt[GWڑ */
    private ConnectionInfo connInfo;
    /** WorkflowServiceManager̃[gIuWFNg */
    private WorkflowServiceManagerRemote wsmr;
    /** ReLXg */
    private Context context;
    /** ZbVID */
    private String session;
    
	/**
	 * [Nt[T[rXANZbT𐶐B
	 *
	 * @param conn ڑ
	 */
	public WorkflowServiceAccessor(ConnectionInfo conn) {
	    
	    if (conn == null) {
	        throw new IllegalArgumentException();
	    }
	    
	    this.connInfo = conn;
		
	    // Oo
	    log.info(StringManager.get("I8001"));
	    log.info("ConnectionInfomation(" + conn.toString() + ")");
	}
    
	/**
	 * [Nt[T[rXANZbT𐶐B
	 *
	 * @param conn ڑ
	 * @param context ReLXg
	 */
	public WorkflowServiceAccessor(ConnectionInfo conn, Context context) {
	    
	    if (conn == null) {
	        throw new IllegalArgumentException();
	    }

	    this.context = context;
	    this.connInfo = conn;
		
	    // Oo
	    log.info(StringManager.get("I8001"));
	    log.info("ConnectionInfomation(" + conn.toString() + ")");
	}
	
	/**
	 * ݂̃ANZbTێĂŃZbVmA
	 * ZbVIDԂB
	 * [Nt[T[rX}l[Wɑ΂āAF؂sB
	 * F؂ɐꍇ́AT[rX}l[W̎QƂێB
	 * close()Ă΂ĂȂꍇ́A܂close()sĂA
	 * ڑJȂB
	 * ̏ꍇAȑÕZbVID͖ƂȂB
	 *
	 * @return ZbVID
	 * @throws ConnectionFailedException F؎s̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String open() 
	throws ConnectionFailedException, RemoteException {
		
	    // ɐڑς݂ǂ`FbN
	    // ڑς݂̏ꍇAZbVIDۑĂ̂ŁA
	    // ZbVIDnullȊȌꍇAɐڑς݂ł
	    // ڑς݂ŁAēxopen()\bhĂԏꍇAclose()ĂڑJȂ
	    if (getSession() != null) {
	        // Oo
	        log.info(StringManager.get("W8001"));
	        try {
	            this.close();
	        } catch (InvalidSessionException ex) {
	            /* ZbVȏꍇ̗O͖ */
	        }
	    }
	    
	    // ڑɁAWorkflowServiceManager̃[gIuWFNg擾
	    try {
			if (context == null) {
		    	Properties prop = new Properties();
				prop.setProperty(
						"java.naming.factory.initial", 
						"com.sun.jndi.cosnaming.CNCtxFactory");
				prop.setProperty(
						"java.naming.provider.url", 
						this.connInfo.getEngineName());
				context = new InitialContext(prop);
			}
	        Object ref = context.lookup(this.connInfo.getScope() + "/" + 
	                                    ServiceNames.NAUTICA_WORKFLOW_SERVICE);
	        this.wsmr = (WorkflowServiceManagerRemote)PortableRemoteObject.narrow(
	                		ref,
	                		WorkflowServiceManagerRemote.class);
	    } catch (NamingException ex) {
	        // l[~OOꍇ
	        // OóF[Nt[GWƐڑł܂łB
	        log.error(StringManager.get("E8001"));
	        // ObZ[WF[Nt[GWƐڑł܂łB
	        throw new ConnectionFailedException(StringManager.get("E8001"), ex);
	    }
	    
	    // WorkflowServiceManager  connect()\bhgpāAF؂sB
	    this.session = this.wsmr.connect(this.connInfo.getUserID(), 
	                                      this.connInfo.getPassword());

	    // OóF[Nt[GWƐڑ܂B
	    log.info(StringManager.get("I8002"));
	    
	    return getSession();
	}
	
	/**
	 * ZbV𖾎IɕBAZbV̓T[o
	 * ^CAEgɂĖɂȂĂ邱ƂB
	 * ̏ꍇ́AInvalidSessionExceptionԂ邪A
	 * Ă܂ȂB
	 *
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void close()
	throws InvalidSessionException, RemoteException {
		
	    try {
	        // [Nt[GWؒf
	        this.wsmr.disconnect(getSession());
	    } finally {
	        // ZbVIDNA
	        this.session = null;
	        
	        // WorkflowServiceManager ̃[gIuWFNgNA
	        this.wsmr = null;
	        
	        // OóF[Nt[GWؒf܂B
	        log.info(StringManager.get("I8003"));
	    }
	}

	/**
	 * `|WgԂB
	 *
	 * @return `|Wg 
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public DefinitionRepositoryRemote getDefinitionRepository()
	throws InvalidSessionException, RemoteException {
		
		return this.wsmr.getDefinitionRepository(getSession());
	}

	/**
	 * ƍڃnhԂB
	 *
	 * @return ƍڃnhԂB
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkItemHandlerRemote getWorkItemHandler()
	throws InvalidSessionException, RemoteException {
		
		return this.wsmr.getWorkItemHandler(getSession());
	}

	/**
	 * [Nt[GWnhԂB
	 *
	 * @return [Nt[GWnh
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkflowEngineHandlerRemote getWorkflowEngineHandler()
	throws InvalidSessionException, RemoteException {
		
		return this.wsmr.getWorkflowEngineHandler(getSession());
	}

	/**
	 * [Nt[ǗnhԂB
	 *
	 * @return [Nt[Ǘnh
	 * @throws InvalidSessionException ZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkflowAdminHandlerRemote getWorkflowAdminHandler()
	throws InvalidSessionException, RemoteException {
		
		return this.wsmr.getWorkflowAdminHandler(getSession());
	}
	
	/**
	 * ZbVID擾
	 * 
	 * @return	ZbVIDBݒ̏ꍇ<code>null</code>ԂB
	 */
	private String getSession() {
	    return this.session;
	}
}
